/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.projsettings.CIFTab;
import com.sun.electric.tool.user.dialogs.projsettings.DXFTab;
import com.sun.electric.tool.user.dialogs.projsettings.GDSTab;
import com.sun.electric.tool.user.dialogs.projsettings.LogicalEffortTab;
import com.sun.electric.tool.user.dialogs.projsettings.NetlistsTab;
import com.sun.electric.tool.user.dialogs.projsettings.ParasiticTab;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import com.sun.electric.tool.user.dialogs.projsettings.ScaleTab;
import com.sun.electric.tool.user.dialogs.projsettings.SkillTab;
import com.sun.electric.tool.user.dialogs.projsettings.TechnologyTab;
import com.sun.electric.tool.user.dialogs.projsettings.VerilogTab;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ProjectSettingsFrame
extends EDialog {
    private JSplitPane splitPane;
    private JTree optionTree;
    JButton cancel;
    JButton ok;
    List<ProjSettingsPanel> optionPanes = new ArrayList<ProjSettingsPanel>();
    private static String currentTabName = "Netlists";
    private static String currentSectionName = "General ";

    public static void projectSettingsCommand() {
        ProjectSettingsFrame dialog = new ProjectSettingsFrame((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public ProjectSettingsFrame(Frame parent, boolean modal) {
        super(parent, modal);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Project Settings");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ProjectSettingsFrame.this.closeDialog(evt);
            }
        });
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Project Settings");
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.optionTree = new JTree(treeModel);
        TreeHandler handler = new TreeHandler(this);
        this.optionTree.addMouseListener(handler);
        this.optionTree.addTreeExpansionListener(handler);
        CIFTab cit = new CIFTab(parent, modal);
        this.optionPanes.add(cit);
        rootNode.add(new DefaultMutableTreeNode(cit.getName()));
        GDSTab gdt = new GDSTab(parent, modal);
        this.optionPanes.add(gdt);
        rootNode.add(new DefaultMutableTreeNode(gdt.getName()));
        DXFTab dxt = new DXFTab(parent, modal);
        this.optionPanes.add(dxt);
        rootNode.add(new DefaultMutableTreeNode(dxt.getName()));
        LogicalEffortTab let = new LogicalEffortTab(parent, modal);
        this.optionPanes.add(let);
        rootNode.add(new DefaultMutableTreeNode(let.getName()));
        NetlistsTab nt = new NetlistsTab(parent, modal);
        this.optionPanes.add(nt);
        rootNode.add(new DefaultMutableTreeNode(nt.getName()));
        ParasiticTab parat = new ParasiticTab(parent, modal);
        this.optionPanes.add(parat);
        rootNode.add(new DefaultMutableTreeNode(parat.getName()));
        ScaleTab scat = new ScaleTab(parent, modal);
        this.optionPanes.add(scat);
        rootNode.add(new DefaultMutableTreeNode(scat.getName()));
        if (IOTool.hasSkill()) {
            SkillTab skt = new SkillTab(parent, modal);
            this.optionPanes.add(skt);
            rootNode.add(new DefaultMutableTreeNode(skt.getName()));
        }
        TechnologyTab tect = new TechnologyTab(parent, modal);
        this.optionPanes.add(tect);
        rootNode.add(new DefaultMutableTreeNode(tect.getName()));
        VerilogTab vet = new VerilogTab(parent, modal);
        this.optionPanes.add(vet);
        rootNode.add(new DefaultMutableTreeNode(vet.getName()));
        TreePath topPath = this.optionTree.getPathForRow(0);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getPathForRow(1);
        this.optionTree.expandPath(topPath);
        this.openSelectedPath(rootNode);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        JScrollPane scrolledTree = new JScrollPane(this.optionTree);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        leftPanel.add((Component)scrolledTree, gbc);
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsFrame.this.helpActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)help, gbc);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsFrame.this.cancelActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.cancel, gbc);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsFrame.this.okActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.ok, gbc);
        this.getRootPane().setDefaultButton(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.splitPane = new JSplitPane(1);
        this.loadOptionPanel();
        this.splitPane.setLeftComponent(leftPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.splitPane, gbc);
        this.pack();
        this.finishInitialization();
    }

    private boolean openSelectedPath(DefaultMutableTreeNode rootNode) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            Object o = node.getUserObject();
            if (o.toString().equals(currentTabName)) {
                this.optionTree.scrollPathToVisible(new TreePath(node.getPath()));
                return true;
            }
            if (!this.openSelectedPath(node)) continue;
            return true;
        }
        return false;
    }

    private void cancelActionPerformed() {
        this.closeDialog(null);
    }

    private void okActionPerformed() {
        new OKUpdate(this, false);
    }

    private void helpActionPerformed() {
        ManualViewer.showProjectSettingHelp(currentTabName);
        this.closeDialog(null);
    }

    private void loadOptionPanel() {
        for (ProjSettingsPanel ti : this.optionPanes) {
            if (!ti.getName().equals(currentTabName)) continue;
            if (!ti.isInited()) {
                ti.init();
                ti.setInited();
            }
            this.splitPane.setRightComponent(ti.getPanel());
            return;
        }
    }

    protected void escapePressed() {
        this.cancelActionPerformed();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TreeHandler
    implements MouseListener,
    TreeExpansionListener {
        private ProjectSettingsFrame dialog;

        TreeHandler(ProjectSettingsFrame dialog) {
            this.dialog = dialog;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            TreePath currentPath = this.dialog.optionTree.getPathForLocation(e.getX(), e.getY());
            if (currentPath == null) {
                return;
            }
            this.dialog.optionTree.setSelectionPath(currentPath);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentPath.getLastPathComponent();
            currentTabName = (String)node.getUserObject();
            this.dialog.optionTree.expandPath(currentPath);
            if (currentTabName.endsWith(" ")) {
                currentSectionName = currentTabName;
            } else {
                this.dialog.loadOptionPanel();
            }
            this.dialog.pack();
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            this.dialog.pack();
        }

        public void treeExpanded(TreeExpansionEvent e) {
            TreePath tp = e.getPath();
            if (tp.getPathCount() == 2) {
                TreePath topPath = this.dialog.optionTree.getPathForRow(0);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)topPath.getLastPathComponent();
                int numChildren = node.getChildCount();
                for (int i = 0; i < numChildren; ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    TreePath descentPath = topPath.pathByAddingChild(child);
                    if (descentPath.getLastPathComponent().equals(tp.getLastPathComponent())) {
                        DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)descentPath.getLastPathComponent();
                        currentSectionName = (String)subNode.getUserObject();
                        continue;
                    }
                    this.dialog.optionTree.collapsePath(descentPath);
                }
            }
            this.dialog.pack();
        }
    }

    private static class OKUpdate
    extends Job {
        private transient ProjectSettingsFrame dialog;
        private Pref.PrefChangeBatch changeBatch;
        private boolean issueWarning;

        private OKUpdate(ProjectSettingsFrame dialog, boolean issueWarning) {
            super("Update Project Settings", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.issueWarning = issueWarning;
            Pref.gatherPrefChanges();
            Pref.clearChangedAllPrefs();
            for (ProjSettingsPanel ti : dialog.optionPanes) {
                if (!ti.isInited()) continue;
                ti.term();
            }
            if (Pref.anyPrefChanged()) {
                this.issueWarning = true;
            }
            this.changeBatch = Pref.getPrefChanges();
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Pref.implementPrefChanges(this.changeBatch);
            return true;
        }

        public void terminateOK() {
            if (this.issueWarning) {
                if (ProjSettings.getLastProjectSettingsFile() != null) {
                    Job.getUserInterface().showInformationMessage("Warning: These changes are only valid for this session of Electric.\nTo save them permanently, use File -> Export -> Project Settings", "Saving Project Setting Changes");
                } else {
                    boolean saveAny = false;
                    Iterator<Library> it = Library.getLibraries();
                    while (it.hasNext()) {
                        Library lib = it.next();
                        if (lib.isHidden() || lib.isChanged()) continue;
                        saveAny = true;
                    }
                    if (saveAny) {
                        int saveSettings;
                        int markCurrent;
                        String defaultOption;
                        Object[] options;
                        Library curLib = Library.getCurrent();
                        if (curLib.isChanged()) {
                            options = new String[]{"Mark All Libs", "Write Proj Settings file", "Do nothing"};
                            defaultOption = options[2];
                            markCurrent = 1000;
                            saveSettings = 1;
                        } else {
                            options = new String[]{"Mark All Libs", "Mark Lib \"" + curLib.getName() + "\"", "Write Proj Settings file", "Do nothing"};
                            defaultOption = options[0];
                            markCurrent = 1;
                            saveSettings = 2;
                        }
                        int i = JOptionPane.showOptionDialog(this.dialog, "Warning: Changed settings must be saved to Library or Project Settings file.\nPlease choose which Libraries to mark for saving, or write project settings file:", "Saving Project Setting Changes", -1, 2, null, options, defaultOption);
                        if (i == 0) {
                            CircuitChangeJobs.markAllLibrariesForSavingCommand();
                        } else if (i == markCurrent) {
                            CircuitChangeJobs.markCurrentLibForSavingCommand();
                        } else if (i == saveSettings) {
                            ProjSettings.exportSettings();
                        }
                    }
                }
            }
            this.dialog.closeDialog(null);
        }
    }
}

