/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.processing.LocalPartitionResult;
import com.sun.electric.tool.ncc.processing.LocalPartitionWires;
import com.sun.electric.tool.ncc.strategy.StratHashParts;
import com.sun.electric.tool.ncc.strategy.StratHashWires;
import com.sun.electric.tool.ncc.strategy.StratPartPopularity;
import com.sun.electric.tool.ncc.strategy.StratPartType;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalPartitioning {
    NccGlobals globals;

    private void partitionPartsUsingLocalInformation(Set<Part> forcedMatchParts) {
        this.globals.status2("Partition Parts using local information");
        if (this.globals.getParts() == null) {
            return;
        }
        LeafList offspring = StratPartType.doYourJob(forcedMatchParts, this.globals);
        if (offspring.size() != 0) {
            // empty if block
        }
        if ((offspring = StratPartPopularity.doYourJob(forcedMatchParts, this.globals)).size() != 0) {
            // empty if block
        }
    }

    private LocalPartitioning(NccGlobals globals) {
        this.globals = globals;
    }

    private void localPartitionPartsAndWires(Set<Part> forcedMatchParts, Set<Wire> forcedMatchWires) {
        this.globals.status2("Begin partitioning based on local characteristics \n");
        this.partitionPartsUsingLocalInformation(forcedMatchParts);
        LocalPartitionWires.doYourJob(forcedMatchWires, this.globals);
        this.globals.status2("End partitioning based on local characteristics ");
    }

    private LocalPartitionResult hashMatchedPartsWires(Set<Part> forcedMatchParts, Set<Wire> forcedMatchWires) {
        GetLeaves partLeaves = new GetLeaves(this.globals.getParts(), this.globals);
        GetLeaves wireLeaves = new GetLeaves(this.globals.getWires(), this.globals);
        LocalPartitionResult lpr = new LocalPartitionResult(partLeaves.getNotMatched(), wireLeaves.getNotMatched(), this.globals);
        ArrayList<EquivRecord> partsToCheck = new ArrayList<EquivRecord>();
        for (EquivRecord er : partLeaves.getMatched()) {
            NetObject no = er.getCircuits().next().getNetObjs().next();
            if (forcedMatchParts.contains(no)) continue;
            partsToCheck.add(er);
        }
        ArrayList<EquivRecord> wiresToCheck = new ArrayList<EquivRecord>();
        for (EquivRecord er : wireLeaves.getMatched()) {
            NetObject no = er.getCircuits().next().getNetObjs().next();
            if (forcedMatchWires.contains(no)) continue;
            wiresToCheck.add(er);
        }
        StratHashParts.doYourJob(partsToCheck.iterator(), this.globals);
        StratHashWires.doYourJob(wiresToCheck.iterator(), this.globals);
        return lpr;
    }

    public static LocalPartitionResult doYourJob(Set<Part> forcedMatchParts, Set<Wire> forcedMatchWires, NccGlobals globals) {
        LocalPartitioning jsl = new LocalPartitioning(globals);
        jsl.localPartitionPartsAndWires(forcedMatchParts, forcedMatchWires);
        return jsl.hashMatchedPartsWires(forcedMatchParts, forcedMatchWires);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetLeaves
    extends Strategy {
        List<EquivRecord> matched = new ArrayList<EquivRecord>();
        List<EquivRecord> notMatched = new ArrayList<EquivRecord>();

        GetLeaves(EquivRecord er, NccGlobals glob) {
            super(glob);
            if (er != null) {
                this.doFor(er);
            }
        }

        @Override
        public LeafList doFor(EquivRecord er) {
            if (er.isLeaf()) {
                if (er.isMatched()) {
                    this.matched.add(er);
                } else {
                    this.notMatched.add(er);
                }
            } else {
                return super.doFor(er);
            }
            return new LeafList();
        }

        public List<EquivRecord> getMatched() {
            return this.matched;
        }

        public List<EquivRecord> getNotMatched() {
            return this.notMatched;
        }
    }
}

