/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.TestNode;

class ChipNode
extends TestNode {
    private int lengthIR;

    public ChipNode(String name, int lengthIR, String comment) {
        super(name, comment);
        this.lengthIR = lengthIR;
    }

    public String toString() {
        return super.toString() + " (IR=" + this.lengthIR + ")";
    }

    int getLengthIR() {
        return this.lengthIR;
    }

    void compare(ChipNode that, String thisFile, String thatFile) {
        int nchainThat;
        int nchainThis;
        System.out.println("Differences for chip " + this);
        super.compare(that, thisFile, thatFile);
        if (this.getLengthIR() != that.getLengthIR()) {
            System.out.println("**** Chip " + this.getName() + " has IR length " + this.getLengthIR() + " in " + thisFile + " but " + that.getLengthIR() + " in " + thatFile);
        }
        if ((nchainThis = this.getChildCount()) != (nchainThat = that.getChildCount())) {
            System.out.println("**** Chip " + thisFile + ":" + this.getPathString(1) + " contains " + nchainThis + " chains, but " + thatFile + ":" + that.getPathString(1) + " contains " + nchainThat + ".  Comparison aborted.");
            Infrastructure.exit(1);
        }
        for (int ichain = 0; ichain < nchainThis; ++ichain) {
            ChainNode thisChain = (ChainNode)this.getChildAt(ichain);
            ChainNode thatChain = (ChainNode)that.getChildAt(ichain);
            thisChain.compare(thatChain, thisFile, thatFile);
        }
    }
}

