/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.geometry.GenMath;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DumpHeap {
    private static final boolean REFERENCES = false;
    private int[] objHash = new int[1];
    private ArrayList<Object> objs = new ArrayList();
    private HashMap<Class, ClassDescriptor> classes;

    private DumpHeap() {
        this.objs.add(null);
        this.classes = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String fileName) {
        try {
            System.gc();
            DumpHeap dumpHeap = new DumpHeap();
            dumpHeap.handler(ClassLoader.class);
            dumpHeap.sweeps(100);
            DataOutputStream s = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            try {
                dumpHeap.write(s);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                s.close();
                throw throwable;
            }
            s.close();
            {
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private ClassDescriptor classDescriptorOf(Class cls) {
        ClassDescriptor cd = this.classes.get(cls);
        if (cd == null) {
            cd = new ClassDescriptor(cls);
            this.classes.put(cls, cd);
        }
        return cd;
    }

    private int handler(Object obj) {
        return this.handler(obj, true);
    }

    private int handler0(Object obj) {
        return this.handler(obj, false);
    }

    private int handler(Object obj, boolean create) {
        if (obj == null) {
            return 0;
        }
        int i = System.identityHashCode(obj) & Integer.MAX_VALUE;
        i %= this.objHash.length;
        int j = 1;
        while (this.objHash[i] != 0) {
            Object o = this.objs.get(this.objHash[i]);
            if (o == obj) {
                return this.objHash[i];
            }
            if ((i += j) >= this.objHash.length) {
                i -= this.objHash.length;
            }
            j += 2;
        }
        if (!create) {
            return 0;
        }
        if (this.objs.size() * 2 <= this.objHash.length - 3) {
            this.objHash[i] = this.objs.size();
            this.objs.add(obj);
            return i;
        }
        this.rehash();
        return this.handler(obj);
    }

    void rehash() {
        int newSize = this.objs.size() * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        int[] newObjHash = new int[GenMath.primeSince(newSize)];
        int k = 0;
        while (k < this.objs.size()) {
            Object obj = this.objs.get(k);
            int i = System.identityHashCode(obj) & Integer.MAX_VALUE;
            i %= newObjHash.length;
            int j = 1;
            while (newObjHash[i] != 0) {
                assert (this.objs.get(newObjHash[i]) != obj);
                if ((i += j) >= newObjHash.length) {
                    i -= newObjHash.length;
                }
                j += 2;
            }
            newObjHash[i] = k++;
        }
        this.objHash = newObjHash;
    }

    private void sweep() throws SecurityException, IllegalAccessException {
        for (int scanned = 1; scanned < this.objs.size(); ++scanned) {
            Field f;
            int i;
            Object obj = this.objs.get(scanned);
            this.handler(obj.getClass());
            if (obj instanceof Object[]) {
                Object[] array = (Object[])obj;
                for (int i2 = 0; i2 < array.length; ++i2) {
                    this.handler(array[i2]);
                }
                continue;
            }
            if (obj instanceof Collection) {
                Collection coll = (Collection)obj;
                Iterator it = coll.iterator();
                while (it.hasNext()) {
                    this.handler(it.next());
                }
                continue;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry entry : map.entrySet()) {
                    this.handler(entry.getKey());
                    this.handler(entry.getValue());
                }
                continue;
            }
            if (obj instanceof String) continue;
            Class cls = obj.getClass();
            ClassDescriptor cd = this.classDescriptorOf(cls);
            for (i = 0; i < cd.fields.length; ++i) {
                f = cd.fields[i];
                this.handler(f.get(obj));
            }
            if (!(obj instanceof Class)) continue;
            cls = (Class)obj;
            cd = this.classDescriptorOf(cls);
            this.handler(cls.getComponentType());
            this.handler(cls.getSuperclass());
            for (i = 0; i < cd.staticFields.length; ++i) {
                f = cd.staticFields[i];
                this.handler(f.get(null));
            }
        }
    }

    private void sweeps(int maxSweep) throws SecurityException, IllegalAccessException {
        int numObjects;
        int numSweep = 0;
        do {
            numObjects = this.objs.size();
            this.sweep();
        } while (++numSweep < maxSweep && this.objs.size() != numObjects);
        System.out.println(numSweep + " sweeps");
    }

    private void write(DataOutputStream out) throws IOException, IllegalAccessException {
        Object obj;
        int h;
        Class<?> cls;
        int numObjs = this.objs.size() - 1;
        out.writeInt(numObjs);
        for (ClassDescriptor cd : this.classes.values()) {
            int i;
            cls = cd.cls;
            int h2 = this.handler0(cd.cls);
            assert (h2 != 0);
            out.writeInt(h2);
            out.writeUTF(cd.cls.getName());
            int mode = cls.isArray() && !cls.getComponentType().isPrimitive() ? 2 : (Collection.class.isAssignableFrom(cls) ? 2 : (Map.class.isAssignableFrom(cls) ? 3 : (cls == String.class ? 1 : (cls == Class.class ? 4 : 0))));
            out.writeByte(mode);
            out.writeInt(cd.staticFields.length);
            for (i = 0; i < cd.staticFields.length; ++i) {
                out.writeUTF(cd.staticFields[i].getName());
            }
            out.writeInt(cd.fields.length);
            for (i = 0; i < cd.fields.length; ++i) {
                out.writeUTF(cd.fields[i].getName());
            }
        }
        out.writeInt(0);
        for (h = 1; h <= numObjs; ++h) {
            obj = this.objs.get(h);
            if (!(obj instanceof String)) continue;
            out.writeInt(h);
            out.writeUTF((String)obj);
        }
        out.writeInt(0);
        for (h = 1; h <= numObjs; ++h) {
            Field f;
            int i;
            Iterator<Object> it;
            obj = this.objs.get(h);
            out.writeInt(this.handler0(obj.getClass()));
            if (obj instanceof Object[]) {
                Object[] array = (Object[])obj;
                out.writeInt(array.length);
                for (int i2 = 0; i2 < array.length; ++i2) {
                    out.writeInt(this.handler0(array[i2]));
                }
                continue;
            }
            if (obj instanceof Collection) {
                Collection coll = (Collection)obj;
                int length = coll.size();
                out.writeInt(length);
                it = coll.iterator();
                for (i = 0; i < length && it.hasNext(); ++i) {
                    out.writeInt(this.handler0(it.next()));
                }
                while (i < length) {
                    out.writeInt(0);
                }
                continue;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                int length = 0;
                out.writeInt(length);
                it = map.entrySet().iterator();
                for (i = 0; i < length && it.hasNext(); ++i) {
                    Map.Entry entry = (Map.Entry)it.next();
                    out.writeInt(this.handler0(entry.getKey()));
                    out.writeInt(this.handler0(entry.getValue()));
                }
                while (i < length) {
                    out.writeInt(0);
                    out.writeInt(0);
                }
                continue;
            }
            if (obj instanceof String) continue;
            cls = obj.getClass();
            ClassDescriptor cd = this.classDescriptorOf(cls);
            for (i = 0; i < cd.fields.length; ++i) {
                f = cd.fields[i];
                out.writeInt(this.handler0(f.get(obj)));
            }
            if (!(obj instanceof Class)) continue;
            cd = this.classDescriptorOf((Class)obj);
            for (i = 0; i < cd.staticFields.length; ++i) {
                f = cd.staticFields[i];
                out.writeInt(this.handler0(f.get(null)));
            }
        }
        out.writeInt(0);
    }

    private class ClassDescriptor
    implements Serializable {
        private final Class cls;
        private final Field[] fields;
        private final Field[] staticFields;

        private ClassDescriptor(Class cls) {
            Field[] flds;
            this.cls = cls;
            ArrayList<Field> fieldList = new ArrayList<Field>();
            ArrayList<Field> staticFieldList = new ArrayList<Field>();
            Class superCls = cls.getSuperclass();
            if (superCls != null) {
                fieldList.addAll(Arrays.asList(((DumpHeap)DumpHeap.this).classDescriptorOf(superCls).fields));
            }
            try {
                flds = cls.getDeclaredFields();
            }
            catch (NoClassDefFoundError e) {
                System.out.println("Can't getDeclaredFields in " + cls);
                flds = new Field[]{};
            }
            for (int i = 0; i < flds.length; ++i) {
                Field f = flds[i];
                Class<?> tf = f.getType();
                if (tf.isPrimitive() || Reference.class.isAssignableFrom(cls) && f.getName().equals("referent")) continue;
                f.setAccessible(true);
                int fm = f.getModifiers();
                if (Modifier.isStatic(fm)) {
                    staticFieldList.add(f);
                    continue;
                }
                fieldList.add(f);
            }
            Field[] NULL_FIELD_ARRAY = new Field[]{};
            this.fields = fieldList.toArray(NULL_FIELD_ARRAY);
            this.staticFields = staticFieldList.toArray(NULL_FIELD_ARRAY);
        }
    }
}

