/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include "InspectorProtocolTypes.h"
#include <wtf/JSONValues.h>
#include <wtf/text/WTFString.h>

namespace Inspector {



namespace Protocol {

// Versions.
namespace Audit {
static constexpr unsigned VERSION = 4;
} // Audit

namespace Recording {
static constexpr unsigned VERSION = 2;
} // Recording
// End of versions.


// Forward declarations.
namespace Animation {
class Animation;
class Effect;
class Keyframe;
class TrackingUpdate;
enum class AnimationState;
enum class PlaybackDirection;
enum class FillMode;
} // Animation

namespace ApplicationCache {
class ApplicationCacheResource;
class ApplicationCache;
class FrameWithManifest;
} // ApplicationCache

namespace Browser {
class Extension;
} // Browser

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
namespace CPUProfiler {
class ThreadInfo;
class Event;
} // CPUProfiler
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

namespace CSS {
class CSSStyleId;
class CSSRuleId;
class PseudoIdMatches;
class InheritedStyleEntry;
class RuleMatch;
class CSSSelector;
class SelectorList;
class CSSStyleAttribute;
class CSSStyleSheetHeader;
class CSSStyleSheetBody;
class CSSRule;
class SourceRange;
class ShorthandEntry;
class CSSPropertyInfo;
class CSSComputedStyleProperty;
class CSSStyle;
class CSSProperty;
class Grouping;
class Font;
class FontVariationAxis;
enum class StyleSheetOrigin;
enum class PseudoId;
enum class ForceablePseudoClass;
enum class CSSPropertyStatus;
enum class LayoutFlag;
enum class LayoutContextTypeChangedMode;
} // CSS

namespace Canvas {
class ContextAttributes;
class Canvas;
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
class ShaderProgram;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
enum class ColorSpace;
enum class ContextType;
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
enum class ProgramType;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
enum class ShaderType;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
} // Canvas

namespace Console {
class Channel;
class ConsoleMessage;
class CallFrame;
class StackTrace;
enum class ChannelSource;
enum class ChannelLevel;
enum class ClearReason;
} // Console

namespace DOM {
class Node;
class DataBinding;
class Rect;
class EventListener;
class AccessibilityProperties;
class RGBAColor;
class HighlightConfig;
class GridOverlayConfig;
class FlexOverlayConfig;
class Styleable;
class FilePayload;
enum class PseudoType;
enum class ShadowRootType;
enum class CustomElementState;
enum class LiveRegionRelevant;
} // DOM

namespace DOMDebugger {
enum class DOMBreakpointType;
enum class EventBreakpointType;
} // DOMDebugger

namespace DOMStorage {
class StorageId;
} // DOMStorage

namespace Database {
class Database;
class Error;
} // Database

namespace Debugger {
class Location;
class BreakpointAction;
class BreakpointOptions;
class FunctionDetails;
class CallFrame;
class Scope;
class ProbeSample;
class AssertPauseReason;
class BreakpointPauseReason;
class CSPViolationPauseReason;
} // Debugger

namespace GenericTypes {
class SearchMatch;
} // GenericTypes

namespace Heap {
class GarbageCollection;
} // Heap

namespace IndexedDB {
class DatabaseWithObjectStores;
class ObjectStore;
class ObjectStoreIndex;
class Key;
class KeyRange;
class DataEntry;
class KeyPath;
} // IndexedDB

namespace LayerTree {
class IntRect;
class Layer;
class CompositingReasons;
} // LayerTree

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
namespace Memory {
class Event;
class CategoryData;
} // Memory
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

namespace Network {
class Headers;
class ResourceTiming;
class Request;
class Response;
class Metrics;
class WebSocketRequest;
class WebSocketResponse;
class WebSocketFrame;
class CachedResource;
class Initiator;
enum class ReferrerPolicy;
enum class NetworkStage;
enum class ResourceErrorType;
} // Network

namespace Page {
class UserPreference;
class Frame;
class FrameResource;
class FrameResourceTree;
class SearchResult;
class Cookie;
class AXNode;
class Insets;
enum class Setting;
enum class UserPreferenceName;
enum class UserPreferenceValue;
enum class ResourceType;
enum class CoordinateSystem;
enum class CookieSameSitePolicy;
enum class ForcedColors;
} // Page

namespace Playwright {
class Cookie;
class SetCookieParam;
class NameValue;
class OriginStorage;
class Geolocation;
enum class CookieSameSitePolicy;
} // Playwright

namespace Recording {
class InitialState;
class Frame;
class Recording;
enum class Type;
enum class Initiator;
} // Recording

namespace Runtime {
class RemoteObject;
class ObjectPreview;
class PropertyPreview;
class EntryPreview;
class CollectionEntry;
class PropertyDescriptor;
class InternalPropertyDescriptor;
class CallArgument;
class ExecutionContextDescription;
class ErrorRange;
class StructureDescription;
class TypeSet;
class TypeDescription;
class TypeLocation;
class BasicBlock;
enum class ExecutionContextType;
enum class SyntaxErrorType;
} // Runtime

namespace ScriptProfiler {
class Event;
class ExpressionLocation;
class StackFrame;
class StackTrace;
class Samples;
enum class EventType;
} // ScriptProfiler

namespace Security {
class Connection;
class Certificate;
class Security;
} // Security

#if defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
namespace ServiceWorker {
class Configuration;
} // ServiceWorker
#endif // defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER

namespace Target {
class TargetInfo;
} // Target

namespace Timeline {
class TimelineEvent;
enum class EventType;
enum class Instrument;
} // Timeline
// End of forward declarations.


// Typedefs.
namespace Animation {
/* Unique Web Animation identifier. */
using AnimationId = String;
} // Animation

namespace Browser {
/* Unique extension identifier. */
using ExtensionId = String;
} // Browser

namespace CSS {
using StyleSheetId = String;
} // CSS

namespace Canvas {
/* Unique canvas identifier. */
using CanvasId = String;
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
/* Unique shader program identifier. */
using ProgramId = String;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
} // Canvas

namespace DOM {
/* Unique DOM node identifier. */
using NodeId = int;
/* Unique event listener identifier. */
using EventListenerId = int;
/* An array of quad vertices, x immediately followed by y for each point, points clock-wise. */
using Quad = JSON::ArrayOf<double>;
} // DOM

namespace DOMStorage {
/* DOM Storage item. */
using Item = JSON::ArrayOf<String>;
} // DOMStorage

namespace Database {
/* Unique identifier of Database object. */
using DatabaseId = String;
} // Database

namespace Debugger {
/* Breakpoint identifier. */
using BreakpointId = String;
/* Breakpoint action identifier. */
using BreakpointActionIdentifier = int;
/* Unique script identifier. */
using ScriptId = String;
/* Call frame identifier. */
using CallFrameId = String;
} // Debugger

namespace Heap {
/* JavaScriptCore HeapSnapshot JSON data. */
using HeapSnapshotData = String;
} // Heap

namespace Input {
/* UTC time in seconds, counted from January 1, 1970. */
using TimeSinceEpoch = double;
} // Input

namespace LayerTree {
/* Unique RenderLayer identifier. */
using LayerId = String;
/* Unique PseudoElement identifier. */
using PseudoElementId = String;
} // LayerTree

namespace Network {
/* Unique loader identifier. */
using LoaderId = String;
/* Unique frame identifier. */
using FrameId = String;
/* Unique request identifier. */
using RequestId = String;
/* Elapsed seconds since frontend connected. */
using Timestamp = double;
/* Number of seconds since epoch. */
using Walltime = double;
} // Network

namespace Playwright {
/* Id of Browser context. */
using ContextID = String;
/* Id of WebPageProxy. */
using PageProxyID = String;
} // Playwright

namespace Runtime {
/* Unique object identifier. */
using RemoteObjectId = String;
/* Id of an execution context. */
using ExecutionContextId = int;
} // Runtime

namespace Screencast {
/* Unique identifier of the screencast. */
using ScreencastId = String;
} // Screencast
// End of typedefs.

namespace Helpers {

JS_EXPORT_PRIVATE String getEnumConstantValue(int code);

template<typename T> String getEnumConstantValue(T enumValue)
{
    return getEnumConstantValue(static_cast<int>(enumValue));
}

} // namespace Helpers

namespace Animation {

enum class AnimationState {
    Ready = 0,
    Delayed = 1,
    Active = 2,
    Canceled = 3,
    Done = 4,
}; // enum class AnimationState

enum class PlaybackDirection {
    Normal = 5,
    Reverse = 6,
    Alternate = 7,
    AlternateReverse = 8,
}; // enum class PlaybackDirection

enum class FillMode {
    None = 9,
    Forwards = 10,
    Backwards = 11,
    Both = 12,
    Auto = 13,
}; // enum class FillMode

class Animation final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AnimationIdSet = 1 << 0,
        AllFieldsSet = (AnimationIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Animation*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Animation;
    public:

        Builder<STATE | AnimationIdSet>& setAnimationId(const String& in_animationId)
        {
            static_assert(!(STATE & AnimationIdSet), "property animationId already set");
            m_result->setString("animationId"_s, in_animationId);
            return castState<AnimationIdSet>();
        }

        Ref<Animation> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Animation) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Animation>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Animation> result = Animation::create()
     *     .setAnimationId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& in_opt_name)
    {
        JSON::ObjectBase::setString("name"_s, in_opt_name);
    }

    void setCssAnimationName(const String& in_opt_cssAnimationName)
    {
        JSON::ObjectBase::setString("cssAnimationName"_s, in_opt_cssAnimationName);
    }

    void setCssTransitionProperty(const String& in_opt_cssTransitionProperty)
    {
        JSON::ObjectBase::setString("cssTransitionProperty"_s, in_opt_cssTransitionProperty);
    }

    void setEffect(Ref<Protocol::Animation::Effect>&& in_opt_effect)
    {
        JSON::ObjectBase::setObject("effect"_s, WTFMove(in_opt_effect));
    }

    void setStackTrace(Ref<Protocol::Console::StackTrace>&& in_opt_stackTrace)
    {
        JSON::ObjectBase::setObject("stackTrace"_s, WTFMove(in_opt_stackTrace));
    }
};

class Effect final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Effect*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Effect;
    public:

        Ref<Effect> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Effect) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Effect>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Effect> result = Effect::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setStartDelay(double in_opt_startDelay)
    {
        JSON::ObjectBase::setDouble("startDelay"_s, in_opt_startDelay);
    }

    void setEndDelay(double in_opt_endDelay)
    {
        JSON::ObjectBase::setDouble("endDelay"_s, in_opt_endDelay);
    }

    void setIterationCount(double in_opt_iterationCount)
    {
        JSON::ObjectBase::setDouble("iterationCount"_s, in_opt_iterationCount);
    }

    void setIterationStart(double in_opt_iterationStart)
    {
        JSON::ObjectBase::setDouble("iterationStart"_s, in_opt_iterationStart);
    }

    void setIterationDuration(double in_opt_iterationDuration)
    {
        JSON::ObjectBase::setDouble("iterationDuration"_s, in_opt_iterationDuration);
    }

    void setTimingFunction(const String& in_opt_timingFunction)
    {
        JSON::ObjectBase::setString("timingFunction"_s, in_opt_timingFunction);
    }

    void setPlaybackDirection(Protocol::Animation::PlaybackDirection in_opt_playbackDirection)
    {
        JSON::ObjectBase::setString("playbackDirection"_s, Protocol::Helpers::getEnumConstantValue(in_opt_playbackDirection));
    }

    void setFillMode(Protocol::Animation::FillMode in_opt_fillMode)
    {
        JSON::ObjectBase::setString("fillMode"_s, Protocol::Helpers::getEnumConstantValue(in_opt_fillMode));
    }

    void setKeyframes(Ref<JSON::ArrayOf<Protocol::Animation::Keyframe>>&& in_opt_keyframes)
    {
        JSON::ObjectBase::setArray("keyframes"_s, WTFMove(in_opt_keyframes));
    }
};

class Keyframe final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        OffsetSet = 1 << 0,
        AllFieldsSet = (OffsetSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Keyframe*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Keyframe;
    public:

        Builder<STATE | OffsetSet>& setOffset(double in_offset)
        {
            static_assert(!(STATE & OffsetSet), "property offset already set");
            m_result->setDouble("offset"_s, in_offset);
            return castState<OffsetSet>();
        }

        Ref<Keyframe> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Keyframe) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Keyframe>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Keyframe> result = Keyframe::create()
     *     .setOffset(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setEasing(const String& in_opt_easing)
    {
        JSON::ObjectBase::setString("easing"_s, in_opt_easing);
    }

    void setStyle(const String& in_opt_style)
    {
        JSON::ObjectBase::setString("style"_s, in_opt_style);
    }
};

class TrackingUpdate final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TrackingAnimationIdSet = 1 << 0,
        AnimationStateSet = 1 << 1,
        AllFieldsSet = (TrackingAnimationIdSet | AnimationStateSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TrackingUpdate*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class TrackingUpdate;
    public:

        Builder<STATE | TrackingAnimationIdSet>& setTrackingAnimationId(const String& in_trackingAnimationId)
        {
            static_assert(!(STATE & TrackingAnimationIdSet), "property trackingAnimationId already set");
            m_result->setString("trackingAnimationId"_s, in_trackingAnimationId);
            return castState<TrackingAnimationIdSet>();
        }

        Builder<STATE | AnimationStateSet>& setAnimationState(Protocol::Animation::AnimationState in_animationState)
        {
            static_assert(!(STATE & AnimationStateSet), "property animationState already set");
            m_result->setString("animationState"_s, Protocol::Helpers::getEnumConstantValue(in_animationState));
            return castState<AnimationStateSet>();
        }

        Ref<TrackingUpdate> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(TrackingUpdate) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TrackingUpdate>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TrackingUpdate> result = TrackingUpdate::create()
     *     .setTrackingAnimationId(...)
     *     .setAnimationState(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setNodeId(int in_opt_nodeId)
    {
        JSON::ObjectBase::setInteger("nodeId"_s, in_opt_nodeId);
    }

    void setAnimationName(const String& in_opt_animationName)
    {
        JSON::ObjectBase::setString("animationName"_s, in_opt_animationName);
    }

    void setTransitionProperty(const String& in_opt_transitionProperty)
    {
        JSON::ObjectBase::setString("transitionProperty"_s, in_opt_transitionProperty);
    }
};

} // Animation

namespace ApplicationCache {

/* Detailed application cache resource information. */
class ApplicationCacheResource final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        SizeSet = 1 << 1,
        TypeSet = 1 << 2,
        AllFieldsSet = (UrlSet | SizeSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ApplicationCacheResource*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ApplicationCacheResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | SizeSet>& setSize(int in_size)
        {
            static_assert(!(STATE & SizeSet), "property size already set");
            m_result->setInteger("size"_s, in_size);
            return castState<SizeSet>();
        }

        Builder<STATE | TypeSet>& setType(const String& in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, in_type);
            return castState<TypeSet>();
        }

        Ref<ApplicationCacheResource> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ApplicationCacheResource) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ApplicationCacheResource>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ApplicationCacheResource> result = ApplicationCacheResource::create()
     *     .setUrl(...)
     *     .setSize(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Detailed application cache information. */
class ApplicationCache final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ManifestURLSet = 1 << 0,
        SizeSet = 1 << 1,
        CreationTimeSet = 1 << 2,
        UpdateTimeSet = 1 << 3,
        ResourcesSet = 1 << 4,
        AllFieldsSet = (ManifestURLSet | SizeSet | CreationTimeSet | UpdateTimeSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ApplicationCache*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ApplicationCache;
    public:

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& in_manifestURL)
        {
            static_assert(!(STATE & ManifestURLSet), "property manifestURL already set");
            m_result->setString("manifestURL"_s, in_manifestURL);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | SizeSet>& setSize(double in_size)
        {
            static_assert(!(STATE & SizeSet), "property size already set");
            m_result->setDouble("size"_s, in_size);
            return castState<SizeSet>();
        }

        Builder<STATE | CreationTimeSet>& setCreationTime(double in_creationTime)
        {
            static_assert(!(STATE & CreationTimeSet), "property creationTime already set");
            m_result->setDouble("creationTime"_s, in_creationTime);
            return castState<CreationTimeSet>();
        }

        Builder<STATE | UpdateTimeSet>& setUpdateTime(double in_updateTime)
        {
            static_assert(!(STATE & UpdateTimeSet), "property updateTime already set");
            m_result->setDouble("updateTime"_s, in_updateTime);
            return castState<UpdateTimeSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(Ref<JSON::ArrayOf<Protocol::ApplicationCache::ApplicationCacheResource>>&& in_resources)
        {
            static_assert(!(STATE & ResourcesSet), "property resources already set");
            m_result->setArray("resources"_s, WTFMove(in_resources));
            return castState<ResourcesSet>();
        }

        Ref<ApplicationCache> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ApplicationCache) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ApplicationCache>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ApplicationCache> result = ApplicationCache::create()
     *     .setManifestURL(...)
     *     .setSize(...)
     *     .setCreationTime(...)
     *     .setUpdateTime(...)
     *     .setResources(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Frame identifier - manifest URL pair. */
class FrameWithManifest final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FrameIdSet = 1 << 0,
        ManifestURLSet = 1 << 1,
        StatusSet = 1 << 2,
        AllFieldsSet = (FrameIdSet | ManifestURLSet | StatusSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FrameWithManifest*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class FrameWithManifest;
    public:

        Builder<STATE | FrameIdSet>& setFrameId(const String& in_frameId)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId already set");
            m_result->setString("frameId"_s, in_frameId);
            return castState<FrameIdSet>();
        }

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& in_manifestURL)
        {
            static_assert(!(STATE & ManifestURLSet), "property manifestURL already set");
            m_result->setString("manifestURL"_s, in_manifestURL);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | StatusSet>& setStatus(int in_status)
        {
            static_assert(!(STATE & StatusSet), "property status already set");
            m_result->setInteger("status"_s, in_status);
            return castState<StatusSet>();
        }

        Ref<FrameWithManifest> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(FrameWithManifest) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FrameWithManifest>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FrameWithManifest> result = FrameWithManifest::create()
     *     .setFrameId(...)
     *     .setManifestURL(...)
     *     .setStatus(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // ApplicationCache

namespace Browser {

/* Information about an extension. */
class Extension final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ExtensionIdSet = 1 << 0,
        NameSet = 1 << 1,
        AllFieldsSet = (ExtensionIdSet | NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Extension*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Extension;
    public:

        Builder<STATE | ExtensionIdSet>& setExtensionId(const String& in_extensionId)
        {
            static_assert(!(STATE & ExtensionIdSet), "property extensionId already set");
            m_result->setString("extensionId"_s, in_extensionId);
            return castState<ExtensionIdSet>();
        }

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Ref<Extension> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Extension) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Extension>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Extension> result = Extension::create()
     *     .setExtensionId(...)
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Browser

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
namespace CPUProfiler {

/* CPU usage for an individual thread. */
class ThreadInfo final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating ThreadInfo.
    enum class Type {
        Main = 14,
        WebKit = 15,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        UsageSet = 1 << 1,
        AllFieldsSet = (NameSet | UsageSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ThreadInfo*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ThreadInfo;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | UsageSet>& setUsage(double in_usage)
        {
            static_assert(!(STATE & UsageSet), "property usage already set");
            m_result->setDouble("usage"_s, in_usage);
            return castState<UsageSet>();
        }

        Ref<ThreadInfo> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ThreadInfo) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ThreadInfo>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ThreadInfo> result = ThreadInfo::create()
     *     .setName(...)
     *     .setUsage(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setType(Type in_opt_type)
    {
        JSON::ObjectBase::setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_opt_type));
    }

    void setTargetId(const String& in_opt_targetId)
    {
        JSON::ObjectBase::setString("targetId"_s, in_opt_targetId);
    }
};

class Event final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TimestampSet = 1 << 0,
        UsageSet = 1 << 1,
        AllFieldsSet = (TimestampSet | UsageSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Event*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Event;
    public:

        Builder<STATE | TimestampSet>& setTimestamp(double in_timestamp)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp already set");
            m_result->setDouble("timestamp"_s, in_timestamp);
            return castState<TimestampSet>();
        }

        Builder<STATE | UsageSet>& setUsage(double in_usage)
        {
            static_assert(!(STATE & UsageSet), "property usage already set");
            m_result->setDouble("usage"_s, in_usage);
            return castState<UsageSet>();
        }

        Ref<Event> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Event) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Event>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Event> result = Event::create()
     *     .setTimestamp(...)
     *     .setUsage(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setThreads(Ref<JSON::ArrayOf<Protocol::CPUProfiler::ThreadInfo>>&& in_opt_threads)
    {
        JSON::ObjectBase::setArray("threads"_s, WTFMove(in_opt_threads));
    }
};

} // CPUProfiler
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

namespace CSS {

/* This object identifies a CSS style in a unique way. */
class CSSStyleId final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        OrdinalSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | OrdinalSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleId*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSStyleId;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& in_styleSheetId)
        {
            static_assert(!(STATE & StyleSheetIdSet), "property styleSheetId already set");
            m_result->setString("styleSheetId"_s, in_styleSheetId);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | OrdinalSet>& setOrdinal(int in_ordinal)
        {
            static_assert(!(STATE & OrdinalSet), "property ordinal already set");
            m_result->setInteger("ordinal"_s, in_ordinal);
            return castState<OrdinalSet>();
        }

        Ref<CSSStyleId> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSStyleId) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyleId>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleId> result = CSSStyleId::create()
     *     .setStyleSheetId(...)
     *     .setOrdinal(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Stylesheet type: "user" for user stylesheets, "user-agent" for user-agent stylesheets, "inspector" for stylesheets created by the inspector (i.e. those holding the "via inspector" rules), "regular" for regular stylesheets. */
enum class StyleSheetOrigin {
    User = 16,
    UserAgent = 17,
    Author = 18,
    Inspector = 19,
}; // enum class StyleSheetOrigin

/* This object identifies a CSS rule in a unique way. */
class CSSRuleId final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        OrdinalSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | OrdinalSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSRuleId*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSRuleId;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& in_styleSheetId)
        {
            static_assert(!(STATE & StyleSheetIdSet), "property styleSheetId already set");
            m_result->setString("styleSheetId"_s, in_styleSheetId);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | OrdinalSet>& setOrdinal(int in_ordinal)
        {
            static_assert(!(STATE & OrdinalSet), "property ordinal already set");
            m_result->setInteger("ordinal"_s, in_ordinal);
            return castState<OrdinalSet>();
        }

        Ref<CSSRuleId> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSRuleId) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSRuleId>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSRuleId> result = CSSRuleId::create()
     *     .setStyleSheetId(...)
     *     .setOrdinal(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Pseudo-style identifier (see <code>enum PseudoId</code> in <code>RenderStyleConstants.h</code>). */
enum class PseudoId {
    FirstLine = 20,
    FirstLetter = 21,
    Highlight = 22,
    Marker = 23,
    Before = 24,
    After = 25,
    Selection = 26,
    Backdrop = 27,
    Scrollbar = 28,
    ScrollbarThumb = 29,
    ScrollbarButton = 30,
    ScrollbarTrack = 31,
    ScrollbarTrackPiece = 32,
    ScrollbarCorner = 33,
    Resizer = 34,
}; // enum class PseudoId

/* Pseudo-style identifier (see <code>enum PseudoId</code> in <code>RenderStyleConstants.h</code>). */
enum class ForceablePseudoClass {
    Active = 2,
    Focus = 35,
    FocusVisible = 36,
    FocusWithin = 37,
    Hover = 38,
    Target = 39,
    Visited = 40,
}; // enum class ForceablePseudoClass

/* CSS rule collection for a single pseudo style. */
class PseudoIdMatches final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        PseudoIdSet = 1 << 0,
        MatchesSet = 1 << 1,
        AllFieldsSet = (PseudoIdSet | MatchesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*PseudoIdMatches*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class PseudoIdMatches;
    public:

        Builder<STATE | PseudoIdSet>& setPseudoId(Protocol::CSS::PseudoId in_pseudoId)
        {
            static_assert(!(STATE & PseudoIdSet), "property pseudoId already set");
            m_result->setString("pseudoId"_s, Protocol::Helpers::getEnumConstantValue(in_pseudoId));
            return castState<PseudoIdSet>();
        }

        Builder<STATE | MatchesSet>& setMatches(Ref<JSON::ArrayOf<Protocol::CSS::RuleMatch>>&& in_matches)
        {
            static_assert(!(STATE & MatchesSet), "property matches already set");
            m_result->setArray("matches"_s, WTFMove(in_matches));
            return castState<MatchesSet>();
        }

        Ref<PseudoIdMatches> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(PseudoIdMatches) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<PseudoIdMatches>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<PseudoIdMatches> result = PseudoIdMatches::create()
     *     .setPseudoId(...)
     *     .setMatches(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS rule collection for a single pseudo style. */
class InheritedStyleEntry final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MatchedCSSRulesSet = 1 << 0,
        AllFieldsSet = (MatchedCSSRulesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InheritedStyleEntry*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class InheritedStyleEntry;
    public:

        Builder<STATE | MatchedCSSRulesSet>& setMatchedCSSRules(Ref<JSON::ArrayOf<Protocol::CSS::RuleMatch>>&& in_matchedCSSRules)
        {
            static_assert(!(STATE & MatchedCSSRulesSet), "property matchedCSSRules already set");
            m_result->setArray("matchedCSSRules"_s, WTFMove(in_matchedCSSRules));
            return castState<MatchedCSSRulesSet>();
        }

        Ref<InheritedStyleEntry> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(InheritedStyleEntry) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<InheritedStyleEntry>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InheritedStyleEntry> result = InheritedStyleEntry::create()
     *     .setMatchedCSSRules(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setInlineStyle(Ref<Protocol::CSS::CSSStyle>&& in_opt_inlineStyle)
    {
        JSON::ObjectBase::setObject("inlineStyle"_s, WTFMove(in_opt_inlineStyle));
    }
};

/* Match data for a CSS rule. */
class RuleMatch final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RuleSet = 1 << 0,
        MatchingSelectorsSet = 1 << 1,
        AllFieldsSet = (RuleSet | MatchingSelectorsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RuleMatch*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class RuleMatch;
    public:

        Builder<STATE | RuleSet>& setRule(Ref<Protocol::CSS::CSSRule>&& in_rule)
        {
            static_assert(!(STATE & RuleSet), "property rule already set");
            m_result->setObject("rule"_s, WTFMove(in_rule));
            return castState<RuleSet>();
        }

        Builder<STATE | MatchingSelectorsSet>& setMatchingSelectors(Ref<JSON::ArrayOf<int>>&& in_matchingSelectors)
        {
            static_assert(!(STATE & MatchingSelectorsSet), "property matchingSelectors already set");
            m_result->setArray("matchingSelectors"_s, WTFMove(in_matchingSelectors));
            return castState<MatchingSelectorsSet>();
        }

        Ref<RuleMatch> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(RuleMatch) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<RuleMatch>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RuleMatch> result = RuleMatch::create()
     *     .setRule(...)
     *     .setMatchingSelectors(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS selector. */
class CSSSelector final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TextSet = 1 << 0,
        AllFieldsSet = (TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSSelector*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSSelector;
    public:

        Builder<STATE | TextSet>& setText(const String& in_text)
        {
            static_assert(!(STATE & TextSet), "property text already set");
            m_result->setString("text"_s, in_text);
            return castState<TextSet>();
        }

        Ref<CSSSelector> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSSelector) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSSelector>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSSelector> result = CSSSelector::create()
     *     .setText(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSpecificity(Ref<JSON::ArrayOf<int>>&& in_opt_specificity)
    {
        JSON::ObjectBase::setArray("specificity"_s, WTFMove(in_opt_specificity));
    }

    void setDynamic(bool in_opt_dynamic)
    {
        JSON::ObjectBase::setBoolean("dynamic"_s, in_opt_dynamic);
    }
};

/* Selector list data. */
class SelectorList final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorsSet = 1 << 0,
        TextSet = 1 << 1,
        AllFieldsSet = (SelectorsSet | TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SelectorList*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class SelectorList;
    public:

        Builder<STATE | SelectorsSet>& setSelectors(Ref<JSON::ArrayOf<Protocol::CSS::CSSSelector>>&& in_selectors)
        {
            static_assert(!(STATE & SelectorsSet), "property selectors already set");
            m_result->setArray("selectors"_s, WTFMove(in_selectors));
            return castState<SelectorsSet>();
        }

        Builder<STATE | TextSet>& setText(const String& in_text)
        {
            static_assert(!(STATE & TextSet), "property text already set");
            m_result->setString("text"_s, in_text);
            return castState<TextSet>();
        }

        Ref<SelectorList> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(SelectorList) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SelectorList>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SelectorList> result = SelectorList::create()
     *     .setSelectors(...)
     *     .setText(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setRange(Ref<Protocol::CSS::SourceRange>&& in_opt_range)
    {
        JSON::ObjectBase::setObject("range"_s, WTFMove(in_opt_range));
    }
};

/* CSS style information for a DOM style attribute. */
class CSSStyleAttribute final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        StyleSet = 1 << 1,
        AllFieldsSet = (NameSet | StyleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleAttribute*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSStyleAttribute;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | StyleSet>& setStyle(Ref<Protocol::CSS::CSSStyle>&& in_style)
        {
            static_assert(!(STATE & StyleSet), "property style already set");
            m_result->setObject("style"_s, WTFMove(in_style));
            return castState<StyleSet>();
        }

        Ref<CSSStyleAttribute> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSStyleAttribute) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyleAttribute>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleAttribute> result = CSSStyleAttribute::create()
     *     .setName(...)
     *     .setStyle(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS stylesheet meta-information. */
class CSSStyleSheetHeader final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        FrameIdSet = 1 << 1,
        SourceURLSet = 1 << 2,
        OriginSet = 1 << 3,
        TitleSet = 1 << 4,
        DisabledSet = 1 << 5,
        IsInlineSet = 1 << 6,
        StartLineSet = 1 << 7,
        StartColumnSet = 1 << 8,
        AllFieldsSet = (StyleSheetIdSet | FrameIdSet | SourceURLSet | OriginSet | TitleSet | DisabledSet | IsInlineSet | StartLineSet | StartColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleSheetHeader*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSStyleSheetHeader;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& in_styleSheetId)
        {
            static_assert(!(STATE & StyleSheetIdSet), "property styleSheetId already set");
            m_result->setString("styleSheetId"_s, in_styleSheetId);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const String& in_frameId)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId already set");
            m_result->setString("frameId"_s, in_frameId);
            return castState<FrameIdSet>();
        }

        Builder<STATE | SourceURLSet>& setSourceURL(const String& in_sourceURL)
        {
            static_assert(!(STATE & SourceURLSet), "property sourceURL already set");
            m_result->setString("sourceURL"_s, in_sourceURL);
            return castState<SourceURLSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(Protocol::CSS::StyleSheetOrigin in_origin)
        {
            static_assert(!(STATE & OriginSet), "property origin already set");
            m_result->setString("origin"_s, Protocol::Helpers::getEnumConstantValue(in_origin));
            return castState<OriginSet>();
        }

        Builder<STATE | TitleSet>& setTitle(const String& in_title)
        {
            static_assert(!(STATE & TitleSet), "property title already set");
            m_result->setString("title"_s, in_title);
            return castState<TitleSet>();
        }

        Builder<STATE | DisabledSet>& setDisabled(bool in_disabled)
        {
            static_assert(!(STATE & DisabledSet), "property disabled already set");
            m_result->setBoolean("disabled"_s, in_disabled);
            return castState<DisabledSet>();
        }

        Builder<STATE | IsInlineSet>& setIsInline(bool in_isInline)
        {
            static_assert(!(STATE & IsInlineSet), "property isInline already set");
            m_result->setBoolean("isInline"_s, in_isInline);
            return castState<IsInlineSet>();
        }

        Builder<STATE | StartLineSet>& setStartLine(double in_startLine)
        {
            static_assert(!(STATE & StartLineSet), "property startLine already set");
            m_result->setDouble("startLine"_s, in_startLine);
            return castState<StartLineSet>();
        }

        Builder<STATE | StartColumnSet>& setStartColumn(double in_startColumn)
        {
            static_assert(!(STATE & StartColumnSet), "property startColumn already set");
            m_result->setDouble("startColumn"_s, in_startColumn);
            return castState<StartColumnSet>();
        }

        Ref<CSSStyleSheetHeader> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSStyleSheetHeader) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyleSheetHeader>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleSheetHeader> result = CSSStyleSheetHeader::create()
     *     .setStyleSheetId(...)
     *     .setFrameId(...)
     *     .setSourceURL(...)
     *     .setOrigin(...)
     *     .setTitle(...)
     *     .setDisabled(...)
     *     .setIsInline(...)
     *     .setStartLine(...)
     *     .setStartColumn(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS stylesheet contents. */
class CSSStyleSheetBody final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        RulesSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | RulesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleSheetBody*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSStyleSheetBody;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& in_styleSheetId)
        {
            static_assert(!(STATE & StyleSheetIdSet), "property styleSheetId already set");
            m_result->setString("styleSheetId"_s, in_styleSheetId);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | RulesSet>& setRules(Ref<JSON::ArrayOf<Protocol::CSS::CSSRule>>&& in_rules)
        {
            static_assert(!(STATE & RulesSet), "property rules already set");
            m_result->setArray("rules"_s, WTFMove(in_rules));
            return castState<RulesSet>();
        }

        Ref<CSSStyleSheetBody> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSStyleSheetBody) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyleSheetBody>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleSheetBody> result = CSSStyleSheetBody::create()
     *     .setStyleSheetId(...)
     *     .setRules(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setText(const String& in_opt_text)
    {
        JSON::ObjectBase::setString("text"_s, in_opt_text);
    }
};

/* CSS rule representation. */
class CSSRule final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorListSet = 1 << 0,
        SourceLineSet = 1 << 1,
        OriginSet = 1 << 2,
        StyleSet = 1 << 3,
        AllFieldsSet = (SelectorListSet | SourceLineSet | OriginSet | StyleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSRule*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSRule;
    public:

        Builder<STATE | SelectorListSet>& setSelectorList(Ref<Protocol::CSS::SelectorList>&& in_selectorList)
        {
            static_assert(!(STATE & SelectorListSet), "property selectorList already set");
            m_result->setObject("selectorList"_s, WTFMove(in_selectorList));
            return castState<SelectorListSet>();
        }

        Builder<STATE | SourceLineSet>& setSourceLine(int in_sourceLine)
        {
            static_assert(!(STATE & SourceLineSet), "property sourceLine already set");
            m_result->setInteger("sourceLine"_s, in_sourceLine);
            return castState<SourceLineSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(Protocol::CSS::StyleSheetOrigin in_origin)
        {
            static_assert(!(STATE & OriginSet), "property origin already set");
            m_result->setString("origin"_s, Protocol::Helpers::getEnumConstantValue(in_origin));
            return castState<OriginSet>();
        }

        Builder<STATE | StyleSet>& setStyle(Ref<Protocol::CSS::CSSStyle>&& in_style)
        {
            static_assert(!(STATE & StyleSet), "property style already set");
            m_result->setObject("style"_s, WTFMove(in_style));
            return castState<StyleSet>();
        }

        Ref<CSSRule> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSRule) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSRule>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSRule> result = CSSRule::create()
     *     .setSelectorList(...)
     *     .setSourceLine(...)
     *     .setOrigin(...)
     *     .setStyle(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setRuleId(Ref<Protocol::CSS::CSSRuleId>&& in_opt_ruleId)
    {
        JSON::ObjectBase::setObject("ruleId"_s, WTFMove(in_opt_ruleId));
    }

    void setSourceURL(const String& in_opt_sourceURL)
    {
        JSON::ObjectBase::setString("sourceURL"_s, in_opt_sourceURL);
    }

    void setGroupings(Ref<JSON::ArrayOf<Protocol::CSS::Grouping>>&& in_opt_groupings)
    {
        JSON::ObjectBase::setArray("groupings"_s, WTFMove(in_opt_groupings));
    }

    void setIsImplicitlyNested(bool in_opt_isImplicitlyNested)
    {
        JSON::ObjectBase::setBoolean("isImplicitlyNested"_s, in_opt_isImplicitlyNested);
    }
};

/* Text range within a resource. */
class SourceRange final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartLineSet = 1 << 0,
        StartColumnSet = 1 << 1,
        EndLineSet = 1 << 2,
        EndColumnSet = 1 << 3,
        AllFieldsSet = (StartLineSet | StartColumnSet | EndLineSet | EndColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SourceRange*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class SourceRange;
    public:

        Builder<STATE | StartLineSet>& setStartLine(int in_startLine)
        {
            static_assert(!(STATE & StartLineSet), "property startLine already set");
            m_result->setInteger("startLine"_s, in_startLine);
            return castState<StartLineSet>();
        }

        Builder<STATE | StartColumnSet>& setStartColumn(int in_startColumn)
        {
            static_assert(!(STATE & StartColumnSet), "property startColumn already set");
            m_result->setInteger("startColumn"_s, in_startColumn);
            return castState<StartColumnSet>();
        }

        Builder<STATE | EndLineSet>& setEndLine(int in_endLine)
        {
            static_assert(!(STATE & EndLineSet), "property endLine already set");
            m_result->setInteger("endLine"_s, in_endLine);
            return castState<EndLineSet>();
        }

        Builder<STATE | EndColumnSet>& setEndColumn(int in_endColumn)
        {
            static_assert(!(STATE & EndColumnSet), "property endColumn already set");
            m_result->setInteger("endColumn"_s, in_endColumn);
            return castState<EndColumnSet>();
        }

        Ref<SourceRange> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(SourceRange) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SourceRange>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SourceRange> result = SourceRange::create()
     *     .setStartLine(...)
     *     .setStartColumn(...)
     *     .setEndLine(...)
     *     .setEndColumn(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class ShorthandEntry final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ShorthandEntry*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ShorthandEntry;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, in_value);
            return castState<ValueSet>();
        }

        Ref<ShorthandEntry> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ShorthandEntry) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ShorthandEntry>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ShorthandEntry> result = ShorthandEntry::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class CSSPropertyInfo final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSPropertyInfo*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSPropertyInfo;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Ref<CSSPropertyInfo> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSPropertyInfo) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSPropertyInfo>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSPropertyInfo> result = CSSPropertyInfo::create()
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setAliases(Ref<JSON::ArrayOf<String>>&& in_opt_aliases)
    {
        JSON::ObjectBase::setArray("aliases"_s, WTFMove(in_opt_aliases));
    }

    void setLonghands(Ref<JSON::ArrayOf<String>>&& in_opt_longhands)
    {
        JSON::ObjectBase::setArray("longhands"_s, WTFMove(in_opt_longhands));
    }

    void setValues(Ref<JSON::ArrayOf<String>>&& in_opt_values)
    {
        JSON::ObjectBase::setArray("values"_s, WTFMove(in_opt_values));
    }

    void setInherited(bool in_opt_inherited)
    {
        JSON::ObjectBase::setBoolean("inherited"_s, in_opt_inherited);
    }
};

class CSSComputedStyleProperty final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSComputedStyleProperty*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSComputedStyleProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, in_value);
            return castState<ValueSet>();
        }

        Ref<CSSComputedStyleProperty> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSComputedStyleProperty) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSComputedStyleProperty>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSComputedStyleProperty> result = CSSComputedStyleProperty::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* CSS style representation. */
class CSSStyle final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CssPropertiesSet = 1 << 0,
        ShorthandEntriesSet = 1 << 1,
        AllFieldsSet = (CssPropertiesSet | ShorthandEntriesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyle*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSStyle;
    public:

        Builder<STATE | CssPropertiesSet>& setCssProperties(Ref<JSON::ArrayOf<Protocol::CSS::CSSProperty>>&& in_cssProperties)
        {
            static_assert(!(STATE & CssPropertiesSet), "property cssProperties already set");
            m_result->setArray("cssProperties"_s, WTFMove(in_cssProperties));
            return castState<CssPropertiesSet>();
        }

        Builder<STATE | ShorthandEntriesSet>& setShorthandEntries(Ref<JSON::ArrayOf<Protocol::CSS::ShorthandEntry>>&& in_shorthandEntries)
        {
            static_assert(!(STATE & ShorthandEntriesSet), "property shorthandEntries already set");
            m_result->setArray("shorthandEntries"_s, WTFMove(in_shorthandEntries));
            return castState<ShorthandEntriesSet>();
        }

        Ref<CSSStyle> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSStyle) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSStyle>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyle> result = CSSStyle::create()
     *     .setCssProperties(...)
     *     .setShorthandEntries(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setStyleId(Ref<Protocol::CSS::CSSStyleId>&& in_opt_styleId)
    {
        JSON::ObjectBase::setObject("styleId"_s, WTFMove(in_opt_styleId));
    }

    void setCssText(const String& in_opt_cssText)
    {
        JSON::ObjectBase::setString("cssText"_s, in_opt_cssText);
    }

    void setRange(Ref<Protocol::CSS::SourceRange>&& in_opt_range)
    {
        JSON::ObjectBase::setObject("range"_s, WTFMove(in_opt_range));
    }

    void setWidth(const String& in_opt_width)
    {
        JSON::ObjectBase::setString("width"_s, in_opt_width);
    }

    void setHeight(const String& in_opt_height)
    {
        JSON::ObjectBase::setString("height"_s, in_opt_height);
    }
};

/* The property status: "active" if the property is effective in the style, "inactive" if the property is overridden by a same-named property in this style later on, "disabled" if the property is disabled by the user, "style" (implied if absent) if the property is reported by the browser rather than by the CSS source parser. */
enum class CSSPropertyStatus {
    Active = 2,
    Inactive = 41,
    Disabled = 42,
    Style = 43,
}; // enum class CSSPropertyStatus

/* CSS style effective visual dimensions and source offsets. */
class CSSProperty final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSProperty*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSSProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, in_value);
            return castState<ValueSet>();
        }

        Ref<CSSProperty> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSSProperty) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSSProperty>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSProperty> result = CSSProperty::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setPriority(const String& in_opt_priority)
    {
        JSON::ObjectBase::setString("priority"_s, in_opt_priority);
    }

    void setImplicit(bool in_opt_implicit)
    {
        JSON::ObjectBase::setBoolean("implicit"_s, in_opt_implicit);
    }

    void setText(const String& in_opt_text)
    {
        JSON::ObjectBase::setString("text"_s, in_opt_text);
    }

    void setParsedOk(bool in_opt_parsedOk)
    {
        JSON::ObjectBase::setBoolean("parsedOk"_s, in_opt_parsedOk);
    }

    void setStatus(Protocol::CSS::CSSPropertyStatus in_opt_status)
    {
        JSON::ObjectBase::setString("status"_s, Protocol::Helpers::getEnumConstantValue(in_opt_status));
    }

    void setRange(Ref<Protocol::CSS::SourceRange>&& in_opt_range)
    {
        JSON::ObjectBase::setObject("range"_s, WTFMove(in_opt_range));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral priorityKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral parsedOkKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral statusKey;
};

/* CSS @media (as well as other users of media queries, like @import, <style>, <link>, etc.), @supports, and @layer descriptor. */
class Grouping final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating Grouping.
    enum class Type {
        MediaRule = 44,
        MediaImportRule = 45,
        MediaLinkNode = 46,
        MediaStyleNode = 47,
        SupportsRule = 48,
        LayerRule = 49,
        LayerImportRule = 50,
        ContainerRule = 51,
        StyleRule = 52,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Grouping*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Grouping;
    public:

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<Grouping> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Grouping) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Grouping>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Grouping> result = Grouping::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setRuleId(Ref<Protocol::CSS::CSSRuleId>&& in_opt_ruleId)
    {
        JSON::ObjectBase::setObject("ruleId"_s, WTFMove(in_opt_ruleId));
    }

    void setText(const String& in_opt_text)
    {
        JSON::ObjectBase::setString("text"_s, in_opt_text);
    }

    void setSourceURL(const String& in_opt_sourceURL)
    {
        JSON::ObjectBase::setString("sourceURL"_s, in_opt_sourceURL);
    }

    void setRange(Ref<Protocol::CSS::SourceRange>&& in_opt_range)
    {
        JSON::ObjectBase::setObject("range"_s, WTFMove(in_opt_range));
    }
};

/* A representation of WebCore::Font. Conceptually this is backed by either a font file on disk or from the network. */
class Font final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DisplayNameSet = 1 << 0,
        VariationAxesSet = 1 << 1,
        AllFieldsSet = (DisplayNameSet | VariationAxesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Font*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Font;
    public:

        Builder<STATE | DisplayNameSet>& setDisplayName(const String& in_displayName)
        {
            static_assert(!(STATE & DisplayNameSet), "property displayName already set");
            m_result->setString("displayName"_s, in_displayName);
            return castState<DisplayNameSet>();
        }

        Builder<STATE | VariationAxesSet>& setVariationAxes(Ref<JSON::ArrayOf<Protocol::CSS::FontVariationAxis>>&& in_variationAxes)
        {
            static_assert(!(STATE & VariationAxesSet), "property variationAxes already set");
            m_result->setArray("variationAxes"_s, WTFMove(in_variationAxes));
            return castState<VariationAxesSet>();
        }

        Ref<Font> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Font) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Font>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Font> result = Font::create()
     *     .setDisplayName(...)
     *     .setVariationAxes(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSynthesizedBold(bool in_opt_synthesizedBold)
    {
        JSON::ObjectBase::setBoolean("synthesizedBold"_s, in_opt_synthesizedBold);
    }

    void setSynthesizedOblique(bool in_opt_synthesizedOblique)
    {
        JSON::ObjectBase::setBoolean("synthesizedOblique"_s, in_opt_synthesizedOblique);
    }
};

/* A single variation axis associated with a Font. */
class FontVariationAxis final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TagSet = 1 << 0,
        MinimumValueSet = 1 << 1,
        MaximumValueSet = 1 << 2,
        DefaultValueSet = 1 << 3,
        AllFieldsSet = (TagSet | MinimumValueSet | MaximumValueSet | DefaultValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FontVariationAxis*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class FontVariationAxis;
    public:

        Builder<STATE | TagSet>& setTag(const String& in_tag)
        {
            static_assert(!(STATE & TagSet), "property tag already set");
            m_result->setString("tag"_s, in_tag);
            return castState<TagSet>();
        }

        Builder<STATE | MinimumValueSet>& setMinimumValue(double in_minimumValue)
        {
            static_assert(!(STATE & MinimumValueSet), "property minimumValue already set");
            m_result->setDouble("minimumValue"_s, in_minimumValue);
            return castState<MinimumValueSet>();
        }

        Builder<STATE | MaximumValueSet>& setMaximumValue(double in_maximumValue)
        {
            static_assert(!(STATE & MaximumValueSet), "property maximumValue already set");
            m_result->setDouble("maximumValue"_s, in_maximumValue);
            return castState<MaximumValueSet>();
        }

        Builder<STATE | DefaultValueSet>& setDefaultValue(double in_defaultValue)
        {
            static_assert(!(STATE & DefaultValueSet), "property defaultValue already set");
            m_result->setDouble("defaultValue"_s, in_defaultValue);
            return castState<DefaultValueSet>();
        }

        Ref<FontVariationAxis> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(FontVariationAxis) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FontVariationAxis>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FontVariationAxis> result = FontVariationAxis::create()
     *     .setTag(...)
     *     .setMinimumValue(...)
     *     .setMaximumValue(...)
     *     .setDefaultValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& in_opt_name)
    {
        JSON::ObjectBase::setString("name"_s, in_opt_name);
    }
};

/* Relevant layout information about the node. Things not in this list are not important to Web Inspector. */
enum class LayoutFlag {
    Rendered = 53,
    Scrollable = 54,
    Flex = 55,
    Grid = 56,
    Event = 57,
}; // enum class LayoutFlag

/* The mode for how layout context type changes are handled (default: <code>Observed</code>). <code>Observed</code> limits handling to those nodes already known to the frontend by other means (generally, this means the node is a visible item in the Elements tab). <code>All</code> informs the frontend of all layout context type changes and all nodes with a known layout context are sent to the frontend. */
enum class LayoutContextTypeChangedMode {
    Observed = 58,
    All = 59,
}; // enum class LayoutContextTypeChangedMode

} // CSS

namespace Canvas {

enum class ColorSpace {
    SRGB = 60,
    DisplayP3 = 61,
}; // enum class ColorSpace

/* The type of rendering context backing the canvas element. */
enum class ContextType {
    Canvas2D = 62,
    OffscreenCanvas2D = 63,
    BitmapRenderer = 64,
    WebGL = 65,
    WebGL2 = 66,
}; // enum class ContextType

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
enum class ProgramType {
    Compute = 67,
    Render = 68,
}; // enum class ProgramType
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
enum class ShaderType {
    Compute = 67,
    Fragment = 69,
    Vertex = 70,
}; // enum class ShaderType
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

/* Drawing surface attributes. */
class ContextAttributes final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ContextAttributes*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ContextAttributes;
    public:

        Ref<ContextAttributes> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ContextAttributes) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ContextAttributes>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ContextAttributes> result = ContextAttributes::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setAlpha(bool in_opt_alpha)
    {
        JSON::ObjectBase::setBoolean("alpha"_s, in_opt_alpha);
    }

    void setColorSpace(Protocol::Canvas::ColorSpace in_opt_colorSpace)
    {
        JSON::ObjectBase::setString("colorSpace"_s, Protocol::Helpers::getEnumConstantValue(in_opt_colorSpace));
    }

    void setDesynchronized(bool in_opt_desynchronized)
    {
        JSON::ObjectBase::setBoolean("desynchronized"_s, in_opt_desynchronized);
    }

    void setDepth(bool in_opt_depth)
    {
        JSON::ObjectBase::setBoolean("depth"_s, in_opt_depth);
    }

    void setStencil(bool in_opt_stencil)
    {
        JSON::ObjectBase::setBoolean("stencil"_s, in_opt_stencil);
    }

    void setAntialias(bool in_opt_antialias)
    {
        JSON::ObjectBase::setBoolean("antialias"_s, in_opt_antialias);
    }

    void setPremultipliedAlpha(bool in_opt_premultipliedAlpha)
    {
        JSON::ObjectBase::setBoolean("premultipliedAlpha"_s, in_opt_premultipliedAlpha);
    }

    void setPreserveDrawingBuffer(bool in_opt_preserveDrawingBuffer)
    {
        JSON::ObjectBase::setBoolean("preserveDrawingBuffer"_s, in_opt_preserveDrawingBuffer);
    }

    void setFailIfMajorPerformanceCaveat(bool in_opt_failIfMajorPerformanceCaveat)
    {
        JSON::ObjectBase::setBoolean("failIfMajorPerformanceCaveat"_s, in_opt_failIfMajorPerformanceCaveat);
    }

    void setPowerPreference(const String& in_opt_powerPreference)
    {
        JSON::ObjectBase::setString("powerPreference"_s, in_opt_powerPreference);
    }
};

/* Information about a canvas for which a rendering context has been created. */
class Canvas final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CanvasIdSet = 1 << 0,
        ContextTypeSet = 1 << 1,
        AllFieldsSet = (CanvasIdSet | ContextTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Canvas*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Canvas;
    public:

        Builder<STATE | CanvasIdSet>& setCanvasId(const String& in_canvasId)
        {
            static_assert(!(STATE & CanvasIdSet), "property canvasId already set");
            m_result->setString("canvasId"_s, in_canvasId);
            return castState<CanvasIdSet>();
        }

        Builder<STATE | ContextTypeSet>& setContextType(Protocol::Canvas::ContextType in_contextType)
        {
            static_assert(!(STATE & ContextTypeSet), "property contextType already set");
            m_result->setString("contextType"_s, Protocol::Helpers::getEnumConstantValue(in_contextType));
            return castState<ContextTypeSet>();
        }

        Ref<Canvas> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Canvas) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Canvas>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Canvas> result = Canvas::create()
     *     .setCanvasId(...)
     *     .setContextType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setNodeId(int in_opt_nodeId)
    {
        JSON::ObjectBase::setInteger("nodeId"_s, in_opt_nodeId);
    }

    void setCssCanvasName(const String& in_opt_cssCanvasName)
    {
        JSON::ObjectBase::setString("cssCanvasName"_s, in_opt_cssCanvasName);
    }

    void setContextAttributes(Ref<Protocol::Canvas::ContextAttributes>&& in_opt_contextAttributes)
    {
        JSON::ObjectBase::setObject("contextAttributes"_s, WTFMove(in_opt_contextAttributes));
    }

    void setMemoryCost(double in_opt_memoryCost)
    {
        JSON::ObjectBase::setDouble("memoryCost"_s, in_opt_memoryCost);
    }

    void setStackTrace(Ref<Protocol::Console::StackTrace>&& in_opt_stackTrace)
    {
        JSON::ObjectBase::setObject("stackTrace"_s, WTFMove(in_opt_stackTrace));
    }
};

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
/* Information about a WebGL/WebGL2 shader program. */
class ShaderProgram final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ProgramIdSet = 1 << 0,
        ProgramTypeSet = 1 << 1,
        CanvasIdSet = 1 << 2,
        AllFieldsSet = (ProgramIdSet | ProgramTypeSet | CanvasIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ShaderProgram*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ShaderProgram;
    public:

        Builder<STATE | ProgramIdSet>& setProgramId(const String& in_programId)
        {
            static_assert(!(STATE & ProgramIdSet), "property programId already set");
            m_result->setString("programId"_s, in_programId);
            return castState<ProgramIdSet>();
        }

        Builder<STATE | ProgramTypeSet>& setProgramType(Protocol::Canvas::ProgramType in_programType)
        {
            static_assert(!(STATE & ProgramTypeSet), "property programType already set");
            m_result->setString("programType"_s, Protocol::Helpers::getEnumConstantValue(in_programType));
            return castState<ProgramTypeSet>();
        }

        Builder<STATE | CanvasIdSet>& setCanvasId(const String& in_canvasId)
        {
            static_assert(!(STATE & CanvasIdSet), "property canvasId already set");
            m_result->setString("canvasId"_s, in_canvasId);
            return castState<CanvasIdSet>();
        }

        Ref<ShaderProgram> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ShaderProgram) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ShaderProgram>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ShaderProgram> result = ShaderProgram::create()
     *     .setProgramId(...)
     *     .setProgramType(...)
     *     .setCanvasId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

} // Canvas

namespace Console {

/* Channels for different types of log messages. */
enum class ChannelSource {
    XML = 71,
    JavaScript = 72,
    Network = 73,
    ConsoleAPI = 74,
    Storage = 75,
    Appcache = 76,
    Rendering = 77,
    CSS = 78,
    Security = 79,
    ContentBlocker = 80,
    Media = 81,
    MediaSource = 82,
    WebRTC = 83,
    ITPDebug = 84,
    PrivateClickMeasurement = 85,
    PaymentRequest = 86,
    Other = 87,
}; // enum class ChannelSource

/* Level of logging. */
enum class ChannelLevel {
    Off = 88,
    Basic = 89,
    Verbose = 90,
}; // enum class ChannelLevel

/* The reason the console is being cleared. */
enum class ClearReason {
    ConsoleAPI = 74,
    MainFrameNavigation = 91,
}; // enum class ClearReason

/* Logging channel. */
class Channel final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SourceSet = 1 << 0,
        LevelSet = 1 << 1,
        AllFieldsSet = (SourceSet | LevelSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Channel*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Channel;
    public:

        Builder<STATE | SourceSet>& setSource(Protocol::Console::ChannelSource in_source)
        {
            static_assert(!(STATE & SourceSet), "property source already set");
            m_result->setString("source"_s, Protocol::Helpers::getEnumConstantValue(in_source));
            return castState<SourceSet>();
        }

        Builder<STATE | LevelSet>& setLevel(Protocol::Console::ChannelLevel in_level)
        {
            static_assert(!(STATE & LevelSet), "property level already set");
            m_result->setString("level"_s, Protocol::Helpers::getEnumConstantValue(in_level));
            return castState<LevelSet>();
        }

        Ref<Channel> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Channel) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Channel>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Channel> result = Channel::create()
     *     .setSource(...)
     *     .setLevel(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Console message. */
class ConsoleMessage final : public JSON::ObjectBase {
public:
    // Named after property name 'level' while generating ConsoleMessage.
    enum class Level {
        Log = 92,
        Info = 93,
        Warning = 94,
        Error = 95,
        Debug = 96,
    }; // enum class Level

    // Named after property name 'type' while generating ConsoleMessage.
    enum class Type {
        Log = 92,
        Dir = 97,
        DirXML = 98,
        Table = 99,
        Trace = 100,
        Clear = 101,
        StartGroup = 102,
        StartGroupCollapsed = 103,
        EndGroup = 104,
        Assert = 105,
        Timing = 106,
        Profile = 107,
        ProfileEnd = 108,
        Image = 109,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        SourceSet = 1 << 0,
        LevelSet = 1 << 1,
        TextSet = 1 << 2,
        AllFieldsSet = (SourceSet | LevelSet | TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ConsoleMessage*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ConsoleMessage;
    public:

        Builder<STATE | SourceSet>& setSource(Protocol::Console::ChannelSource in_source)
        {
            static_assert(!(STATE & SourceSet), "property source already set");
            m_result->setString("source"_s, Protocol::Helpers::getEnumConstantValue(in_source));
            return castState<SourceSet>();
        }

        Builder<STATE | LevelSet>& setLevel(Level in_level)
        {
            static_assert(!(STATE & LevelSet), "property level already set");
            m_result->setString("level"_s, Protocol::Helpers::getEnumConstantValue(in_level));
            return castState<LevelSet>();
        }

        Builder<STATE | TextSet>& setText(const String& in_text)
        {
            static_assert(!(STATE & TextSet), "property text already set");
            m_result->setString("text"_s, in_text);
            return castState<TextSet>();
        }

        Ref<ConsoleMessage> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ConsoleMessage) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ConsoleMessage>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ConsoleMessage> result = ConsoleMessage::create()
     *     .setSource(...)
     *     .setLevel(...)
     *     .setText(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setType(Type in_opt_type)
    {
        JSON::ObjectBase::setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_opt_type));
    }

    void setUrl(const String& in_opt_url)
    {
        JSON::ObjectBase::setString("url"_s, in_opt_url);
    }

    void setLine(int in_opt_line)
    {
        JSON::ObjectBase::setInteger("line"_s, in_opt_line);
    }

    void setColumn(int in_opt_column)
    {
        JSON::ObjectBase::setInteger("column"_s, in_opt_column);
    }

    void setRepeatCount(int in_opt_repeatCount)
    {
        JSON::ObjectBase::setInteger("repeatCount"_s, in_opt_repeatCount);
    }

    void setParameters(Ref<JSON::ArrayOf<Protocol::Runtime::RemoteObject>>&& in_opt_parameters)
    {
        JSON::ObjectBase::setArray("parameters"_s, WTFMove(in_opt_parameters));
    }

    void setStackTrace(Ref<Protocol::Console::StackTrace>&& in_opt_stackTrace)
    {
        JSON::ObjectBase::setObject("stackTrace"_s, WTFMove(in_opt_stackTrace));
    }

    void setNetworkRequestId(const String& in_opt_networkRequestId)
    {
        JSON::ObjectBase::setString("networkRequestId"_s, in_opt_networkRequestId);
    }

    void setTimestamp(double in_opt_timestamp)
    {
        JSON::ObjectBase::setDouble("timestamp"_s, in_opt_timestamp);
    }
};

/* Stack entry for console errors and assertions. */
class CallFrame final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FunctionNameSet = 1 << 0,
        UrlSet = 1 << 1,
        ScriptIdSet = 1 << 2,
        LineNumberSet = 1 << 3,
        ColumnNumberSet = 1 << 4,
        AllFieldsSet = (FunctionNameSet | UrlSet | ScriptIdSet | LineNumberSet | ColumnNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CallFrame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CallFrame;
    public:

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& in_functionName)
        {
            static_assert(!(STATE & FunctionNameSet), "property functionName already set");
            m_result->setString("functionName"_s, in_functionName);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | ScriptIdSet>& setScriptId(const String& in_scriptId)
        {
            static_assert(!(STATE & ScriptIdSet), "property scriptId already set");
            m_result->setString("scriptId"_s, in_scriptId);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int in_lineNumber)
        {
            static_assert(!(STATE & LineNumberSet), "property lineNumber already set");
            m_result->setInteger("lineNumber"_s, in_lineNumber);
            return castState<LineNumberSet>();
        }

        Builder<STATE | ColumnNumberSet>& setColumnNumber(int in_columnNumber)
        {
            static_assert(!(STATE & ColumnNumberSet), "property columnNumber already set");
            m_result->setInteger("columnNumber"_s, in_columnNumber);
            return castState<ColumnNumberSet>();
        }

        Ref<CallFrame> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CallFrame) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CallFrame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CallFrame> result = CallFrame::create()
     *     .setFunctionName(...)
     *     .setUrl(...)
     *     .setScriptId(...)
     *     .setLineNumber(...)
     *     .setColumnNumber(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Call frames for async function calls, console assertions, and error messages. */
class StackTrace final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallFramesSet = 1 << 0,
        AllFieldsSet = (CallFramesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StackTrace*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class StackTrace;
    public:

        Builder<STATE | CallFramesSet>& setCallFrames(Ref<JSON::ArrayOf<Protocol::Console::CallFrame>>&& in_callFrames)
        {
            static_assert(!(STATE & CallFramesSet), "property callFrames already set");
            m_result->setArray("callFrames"_s, WTFMove(in_callFrames));
            return castState<CallFramesSet>();
        }

        Ref<StackTrace> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(StackTrace) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StackTrace>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StackTrace> result = StackTrace::create()
     *     .setCallFrames(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setTopCallFrameIsBoundary(bool in_opt_topCallFrameIsBoundary)
    {
        JSON::ObjectBase::setBoolean("topCallFrameIsBoundary"_s, in_opt_topCallFrameIsBoundary);
    }

    void setTruncated(bool in_opt_truncated)
    {
        JSON::ObjectBase::setBoolean("truncated"_s, in_opt_truncated);
    }

    void setParentStackTrace(Ref<Protocol::Console::StackTrace>&& in_opt_parentStackTrace)
    {
        JSON::ObjectBase::setObject("parentStackTrace"_s, WTFMove(in_opt_parentStackTrace));
    }
};

} // Console

namespace DOM {

/* Pseudo element type. */
enum class PseudoType {
    Before = 24,
    After = 25,
}; // enum class PseudoType

/* Shadow root type. */
enum class ShadowRootType {
    UserAgent = 17,
    Open = 110,
    Closed = 111,
}; // enum class ShadowRootType

/* Custom element state. */
enum class CustomElementState {
    Builtin = 112,
    Custom = 113,
    Waiting = 114,
    Failed = 115,
}; // enum class CustomElementState

/* Token values of @aria-relevant attribute. */
enum class LiveRegionRelevant {
    Additions = 116,
    Removals = 117,
    Text = 118,
}; // enum class LiveRegionRelevant

/* DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes. DOMNode is a base node mirror type. */
class Node final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NodeIdSet = 1 << 0,
        NodeTypeSet = 1 << 1,
        NodeNameSet = 1 << 2,
        LocalNameSet = 1 << 3,
        NodeValueSet = 1 << 4,
        AllFieldsSet = (NodeIdSet | NodeTypeSet | NodeNameSet | LocalNameSet | NodeValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Node*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Node;
    public:

        Builder<STATE | NodeIdSet>& setNodeId(int in_nodeId)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId already set");
            m_result->setInteger("nodeId"_s, in_nodeId);
            return castState<NodeIdSet>();
        }

        Builder<STATE | NodeTypeSet>& setNodeType(int in_nodeType)
        {
            static_assert(!(STATE & NodeTypeSet), "property nodeType already set");
            m_result->setInteger("nodeType"_s, in_nodeType);
            return castState<NodeTypeSet>();
        }

        Builder<STATE | NodeNameSet>& setNodeName(const String& in_nodeName)
        {
            static_assert(!(STATE & NodeNameSet), "property nodeName already set");
            m_result->setString("nodeName"_s, in_nodeName);
            return castState<NodeNameSet>();
        }

        Builder<STATE | LocalNameSet>& setLocalName(const String& in_localName)
        {
            static_assert(!(STATE & LocalNameSet), "property localName already set");
            m_result->setString("localName"_s, in_localName);
            return castState<LocalNameSet>();
        }

        Builder<STATE | NodeValueSet>& setNodeValue(const String& in_nodeValue)
        {
            static_assert(!(STATE & NodeValueSet), "property nodeValue already set");
            m_result->setString("nodeValue"_s, in_nodeValue);
            return castState<NodeValueSet>();
        }

        Ref<Node> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Node) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Node>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Node> result = Node::create()
     *     .setNodeId(...)
     *     .setNodeType(...)
     *     .setNodeName(...)
     *     .setLocalName(...)
     *     .setNodeValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setFrameId(const String& in_opt_frameId)
    {
        JSON::ObjectBase::setString("frameId"_s, in_opt_frameId);
    }

    void setChildNodeCount(int in_opt_childNodeCount)
    {
        JSON::ObjectBase::setInteger("childNodeCount"_s, in_opt_childNodeCount);
    }

    void setChildren(Ref<JSON::ArrayOf<Protocol::DOM::Node>>&& in_opt_children)
    {
        JSON::ObjectBase::setArray("children"_s, WTFMove(in_opt_children));
    }

    void setAttributes(Ref<JSON::ArrayOf<String>>&& in_opt_attributes)
    {
        JSON::ObjectBase::setArray("attributes"_s, WTFMove(in_opt_attributes));
    }

    void setDocumentURL(const String& in_opt_documentURL)
    {
        JSON::ObjectBase::setString("documentURL"_s, in_opt_documentURL);
    }

    void setBaseURL(const String& in_opt_baseURL)
    {
        JSON::ObjectBase::setString("baseURL"_s, in_opt_baseURL);
    }

    void setPublicId(const String& in_opt_publicId)
    {
        JSON::ObjectBase::setString("publicId"_s, in_opt_publicId);
    }

    void setSystemId(const String& in_opt_systemId)
    {
        JSON::ObjectBase::setString("systemId"_s, in_opt_systemId);
    }

    void setXmlVersion(const String& in_opt_xmlVersion)
    {
        JSON::ObjectBase::setString("xmlVersion"_s, in_opt_xmlVersion);
    }

    void setName(const String& in_opt_name)
    {
        JSON::ObjectBase::setString("name"_s, in_opt_name);
    }

    void setValue(const String& in_opt_value)
    {
        JSON::ObjectBase::setString("value"_s, in_opt_value);
    }

    void setPseudoType(Protocol::DOM::PseudoType in_opt_pseudoType)
    {
        JSON::ObjectBase::setString("pseudoType"_s, Protocol::Helpers::getEnumConstantValue(in_opt_pseudoType));
    }

    void setShadowRootType(Protocol::DOM::ShadowRootType in_opt_shadowRootType)
    {
        JSON::ObjectBase::setString("shadowRootType"_s, Protocol::Helpers::getEnumConstantValue(in_opt_shadowRootType));
    }

    void setCustomElementState(Protocol::DOM::CustomElementState in_opt_customElementState)
    {
        JSON::ObjectBase::setString("customElementState"_s, Protocol::Helpers::getEnumConstantValue(in_opt_customElementState));
    }

    void setContentDocument(Ref<Protocol::DOM::Node>&& in_opt_contentDocument)
    {
        JSON::ObjectBase::setObject("contentDocument"_s, WTFMove(in_opt_contentDocument));
    }

    void setShadowRoots(Ref<JSON::ArrayOf<Protocol::DOM::Node>>&& in_opt_shadowRoots)
    {
        JSON::ObjectBase::setArray("shadowRoots"_s, WTFMove(in_opt_shadowRoots));
    }

    void setTemplateContent(Ref<Protocol::DOM::Node>&& in_opt_templateContent)
    {
        JSON::ObjectBase::setObject("templateContent"_s, WTFMove(in_opt_templateContent));
    }

    void setPseudoElements(Ref<JSON::ArrayOf<Protocol::DOM::Node>>&& in_opt_pseudoElements)
    {
        JSON::ObjectBase::setArray("pseudoElements"_s, WTFMove(in_opt_pseudoElements));
    }

    void setContentSecurityPolicyHash(const String& in_opt_contentSecurityPolicyHash)
    {
        JSON::ObjectBase::setString("contentSecurityPolicyHash"_s, in_opt_contentSecurityPolicyHash);
    }

    void setLayoutFlags(Ref<JSON::ArrayOf<String>>&& in_opt_layoutFlags)
    {
        JSON::ObjectBase::setArray("layoutFlags"_s, WTFMove(in_opt_layoutFlags));
    }
};

/* Relationship between data that is associated with a node and the node itself. */
class DataBinding final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        BindingSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (BindingSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*DataBinding*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class DataBinding;
    public:

        Builder<STATE | BindingSet>& setBinding(const String& in_binding)
        {
            static_assert(!(STATE & BindingSet), "property binding already set");
            m_result->setString("binding"_s, in_binding);
            return castState<BindingSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, in_value);
            return castState<ValueSet>();
        }

        Ref<DataBinding> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(DataBinding) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<DataBinding>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<DataBinding> result = DataBinding::create()
     *     .setBinding(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setType(const String& in_opt_type)
    {
        JSON::ObjectBase::setString("type"_s, in_opt_type);
    }
};

class Rect final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        WidthSet = 1 << 2,
        HeightSet = 1 << 3,
        AllFieldsSet = (XSet | YSet | WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Rect*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Rect;
    public:

        Builder<STATE | XSet>& setX(int in_x)
        {
            static_assert(!(STATE & XSet), "property x already set");
            m_result->setInteger("x"_s, in_x);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(int in_y)
        {
            static_assert(!(STATE & YSet), "property y already set");
            m_result->setInteger("y"_s, in_y);
            return castState<YSet>();
        }

        Builder<STATE | WidthSet>& setWidth(int in_width)
        {
            static_assert(!(STATE & WidthSet), "property width already set");
            m_result->setInteger("width"_s, in_width);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(int in_height)
        {
            static_assert(!(STATE & HeightSet), "property height already set");
            m_result->setInteger("height"_s, in_height);
            return castState<HeightSet>();
        }

        Ref<Rect> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Rect) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Rect>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Rect> result = Rect::create()
     *     .setX(...)
     *     .setY(...)
     *     .setWidth(...)
     *     .setHeight(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* A structure holding event listener properties. */
class EventListener final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        EventListenerIdSet = 1 << 0,
        TypeSet = 1 << 1,
        UseCaptureSet = 1 << 2,
        IsAttributeSet = 1 << 3,
        AllFieldsSet = (EventListenerIdSet | TypeSet | UseCaptureSet | IsAttributeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*EventListener*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class EventListener;
    public:

        Builder<STATE | EventListenerIdSet>& setEventListenerId(int in_eventListenerId)
        {
            static_assert(!(STATE & EventListenerIdSet), "property eventListenerId already set");
            m_result->setInteger("eventListenerId"_s, in_eventListenerId);
            return castState<EventListenerIdSet>();
        }

        Builder<STATE | TypeSet>& setType(const String& in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, in_type);
            return castState<TypeSet>();
        }

        Builder<STATE | UseCaptureSet>& setUseCapture(bool in_useCapture)
        {
            static_assert(!(STATE & UseCaptureSet), "property useCapture already set");
            m_result->setBoolean("useCapture"_s, in_useCapture);
            return castState<UseCaptureSet>();
        }

        Builder<STATE | IsAttributeSet>& setIsAttribute(bool in_isAttribute)
        {
            static_assert(!(STATE & IsAttributeSet), "property isAttribute already set");
            m_result->setBoolean("isAttribute"_s, in_isAttribute);
            return castState<IsAttributeSet>();
        }

        Ref<EventListener> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(EventListener) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<EventListener>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<EventListener> result = EventListener::create()
     *     .setEventListenerId(...)
     *     .setType(...)
     *     .setUseCapture(...)
     *     .setIsAttribute(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setNodeId(int in_opt_nodeId)
    {
        JSON::ObjectBase::setInteger("nodeId"_s, in_opt_nodeId);
    }

    void setOnWindow(bool in_opt_onWindow)
    {
        JSON::ObjectBase::setBoolean("onWindow"_s, in_opt_onWindow);
    }

    void setLocation(Ref<Protocol::Debugger::Location>&& in_opt_location)
    {
        JSON::ObjectBase::setObject("location"_s, WTFMove(in_opt_location));
    }

    void setHandlerName(const String& in_opt_handlerName)
    {
        JSON::ObjectBase::setString("handlerName"_s, in_opt_handlerName);
    }

    void setPassive(bool in_opt_passive)
    {
        JSON::ObjectBase::setBoolean("passive"_s, in_opt_passive);
    }

    void setOnce(bool in_opt_once)
    {
        JSON::ObjectBase::setBoolean("once"_s, in_opt_once);
    }

    void setDisabled(bool in_opt_disabled)
    {
        JSON::ObjectBase::setBoolean("disabled"_s, in_opt_disabled);
    }

    void setHasBreakpoint(bool in_opt_hasBreakpoint)
    {
        JSON::ObjectBase::setBoolean("hasBreakpoint"_s, in_opt_hasBreakpoint);
    }
};

/* A structure holding accessibility properties. */
class AccessibilityProperties final : public JSON::ObjectBase {
public:
    // Named after property name 'checked' while generating AccessibilityProperties.
    enum class Checked {
        True = 119,
        False = 120,
        Mixed = 121,
    }; // enum class Checked

    // Named after property name 'current' while generating AccessibilityProperties.
    enum class Current {
        True = 119,
        False = 120,
        Page = 122,
        Step = 123,
        Location = 124,
        Date = 125,
        Time = 126,
    }; // enum class Current

    // Named after property name 'invalid' while generating AccessibilityProperties.
    enum class Invalid {
        True = 119,
        False = 120,
        Grammar = 127,
        Spelling = 128,
    }; // enum class Invalid

    // Named after property name 'liveRegionStatus' while generating AccessibilityProperties.
    enum class LiveRegionStatus {
        Assertive = 129,
        Polite = 130,
        Off = 88,
    }; // enum class LiveRegionStatus

    enum {
        NoFieldsSet = 0,
        ExistsSet = 1 << 0,
        LabelSet = 1 << 1,
        NodeIdSet = 1 << 2,
        RoleSet = 1 << 3,
        AllFieldsSet = (ExistsSet | LabelSet | NodeIdSet | RoleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*AccessibilityProperties*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class AccessibilityProperties;
    public:

        Builder<STATE | ExistsSet>& setExists(bool in_exists)
        {
            static_assert(!(STATE & ExistsSet), "property exists already set");
            m_result->setBoolean("exists"_s, in_exists);
            return castState<ExistsSet>();
        }

        Builder<STATE | LabelSet>& setLabel(const String& in_label)
        {
            static_assert(!(STATE & LabelSet), "property label already set");
            m_result->setString("label"_s, in_label);
            return castState<LabelSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int in_nodeId)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId already set");
            m_result->setInteger("nodeId"_s, in_nodeId);
            return castState<NodeIdSet>();
        }

        Builder<STATE | RoleSet>& setRole(const String& in_role)
        {
            static_assert(!(STATE & RoleSet), "property role already set");
            m_result->setString("role"_s, in_role);
            return castState<RoleSet>();
        }

        Ref<AccessibilityProperties> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(AccessibilityProperties) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<AccessibilityProperties>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<AccessibilityProperties> result = AccessibilityProperties::create()
     *     .setExists(...)
     *     .setLabel(...)
     *     .setNodeId(...)
     *     .setRole(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setActiveDescendantNodeId(int in_opt_activeDescendantNodeId)
    {
        JSON::ObjectBase::setInteger("activeDescendantNodeId"_s, in_opt_activeDescendantNodeId);
    }

    void setBusy(bool in_opt_busy)
    {
        JSON::ObjectBase::setBoolean("busy"_s, in_opt_busy);
    }

    void setChecked(Checked in_opt_checked)
    {
        JSON::ObjectBase::setString("checked"_s, Protocol::Helpers::getEnumConstantValue(in_opt_checked));
    }

    void setChildNodeIds(Ref<JSON::ArrayOf<int>>&& in_opt_childNodeIds)
    {
        JSON::ObjectBase::setArray("childNodeIds"_s, WTFMove(in_opt_childNodeIds));
    }

    void setControlledNodeIds(Ref<JSON::ArrayOf<int>>&& in_opt_controlledNodeIds)
    {
        JSON::ObjectBase::setArray("controlledNodeIds"_s, WTFMove(in_opt_controlledNodeIds));
    }

    void setCurrent(Current in_opt_current)
    {
        JSON::ObjectBase::setString("current"_s, Protocol::Helpers::getEnumConstantValue(in_opt_current));
    }

    void setDisabled(bool in_opt_disabled)
    {
        JSON::ObjectBase::setBoolean("disabled"_s, in_opt_disabled);
    }

    void setHeadingLevel(double in_opt_headingLevel)
    {
        JSON::ObjectBase::setDouble("headingLevel"_s, in_opt_headingLevel);
    }

    void setHierarchyLevel(double in_opt_hierarchyLevel)
    {
        JSON::ObjectBase::setDouble("hierarchyLevel"_s, in_opt_hierarchyLevel);
    }

    void setIsPopUpButton(bool in_opt_isPopUpButton)
    {
        JSON::ObjectBase::setBoolean("isPopUpButton"_s, in_opt_isPopUpButton);
    }

    void setExpanded(bool in_opt_expanded)
    {
        JSON::ObjectBase::setBoolean("expanded"_s, in_opt_expanded);
    }

    void setFlowedNodeIds(Ref<JSON::ArrayOf<int>>&& in_opt_flowedNodeIds)
    {
        JSON::ObjectBase::setArray("flowedNodeIds"_s, WTFMove(in_opt_flowedNodeIds));
    }

    void setFocused(bool in_opt_focused)
    {
        JSON::ObjectBase::setBoolean("focused"_s, in_opt_focused);
    }

    void setIgnored(bool in_opt_ignored)
    {
        JSON::ObjectBase::setBoolean("ignored"_s, in_opt_ignored);
    }

    void setIgnoredByDefault(bool in_opt_ignoredByDefault)
    {
        JSON::ObjectBase::setBoolean("ignoredByDefault"_s, in_opt_ignoredByDefault);
    }

    void setInvalid(Invalid in_opt_invalid)
    {
        JSON::ObjectBase::setString("invalid"_s, Protocol::Helpers::getEnumConstantValue(in_opt_invalid));
    }

    void setHidden(bool in_opt_hidden)
    {
        JSON::ObjectBase::setBoolean("hidden"_s, in_opt_hidden);
    }

    void setLiveRegionAtomic(bool in_opt_liveRegionAtomic)
    {
        JSON::ObjectBase::setBoolean("liveRegionAtomic"_s, in_opt_liveRegionAtomic);
    }

    void setLiveRegionRelevant(Ref<JSON::ArrayOf<String>>&& in_opt_liveRegionRelevant)
    {
        JSON::ObjectBase::setArray("liveRegionRelevant"_s, WTFMove(in_opt_liveRegionRelevant));
    }

    void setLiveRegionStatus(LiveRegionStatus in_opt_liveRegionStatus)
    {
        JSON::ObjectBase::setString("liveRegionStatus"_s, Protocol::Helpers::getEnumConstantValue(in_opt_liveRegionStatus));
    }

    void setMouseEventNodeId(int in_opt_mouseEventNodeId)
    {
        JSON::ObjectBase::setInteger("mouseEventNodeId"_s, in_opt_mouseEventNodeId);
    }

    void setOwnedNodeIds(Ref<JSON::ArrayOf<int>>&& in_opt_ownedNodeIds)
    {
        JSON::ObjectBase::setArray("ownedNodeIds"_s, WTFMove(in_opt_ownedNodeIds));
    }

    void setParentNodeId(int in_opt_parentNodeId)
    {
        JSON::ObjectBase::setInteger("parentNodeId"_s, in_opt_parentNodeId);
    }

    void setPressed(bool in_opt_pressed)
    {
        JSON::ObjectBase::setBoolean("pressed"_s, in_opt_pressed);
    }

    void setReadonly(bool in_opt_readonly)
    {
        JSON::ObjectBase::setBoolean("readonly"_s, in_opt_readonly);
    }

    void setRequired(bool in_opt_required)
    {
        JSON::ObjectBase::setBoolean("required"_s, in_opt_required);
    }

    void setSelected(bool in_opt_selected)
    {
        JSON::ObjectBase::setBoolean("selected"_s, in_opt_selected);
    }

    void setSelectedChildNodeIds(Ref<JSON::ArrayOf<int>>&& in_opt_selectedChildNodeIds)
    {
        JSON::ObjectBase::setArray("selectedChildNodeIds"_s, WTFMove(in_opt_selectedChildNodeIds));
    }
};

/* A structure holding an RGBA color. */
class RGBAColor final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        RSet = 1 << 0,
        GSet = 1 << 1,
        BSet = 1 << 2,
        AllFieldsSet = (RSet | GSet | BSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RGBAColor*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class RGBAColor;
    public:

        Builder<STATE | RSet>& setR(int in_r)
        {
            static_assert(!(STATE & RSet), "property r already set");
            m_result->setInteger("r"_s, in_r);
            return castState<RSet>();
        }

        Builder<STATE | GSet>& setG(int in_g)
        {
            static_assert(!(STATE & GSet), "property g already set");
            m_result->setInteger("g"_s, in_g);
            return castState<GSet>();
        }

        Builder<STATE | BSet>& setB(int in_b)
        {
            static_assert(!(STATE & BSet), "property b already set");
            m_result->setInteger("b"_s, in_b);
            return castState<BSet>();
        }

        Ref<RGBAColor> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(RGBAColor) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<RGBAColor>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RGBAColor> result = RGBAColor::create()
     *     .setR(...)
     *     .setG(...)
     *     .setB(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setA(double in_opt_a)
    {
        JSON::ObjectBase::setDouble("a"_s, in_opt_a);
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral rKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral gKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral bKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral aKey;
};

/* Configuration data for the highlighting of page elements. */
class HighlightConfig final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*HighlightConfig*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class HighlightConfig;
    public:

        Ref<HighlightConfig> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(HighlightConfig) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<HighlightConfig>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<HighlightConfig> result = HighlightConfig::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setShowInfo(bool in_opt_showInfo)
    {
        JSON::ObjectBase::setBoolean("showInfo"_s, in_opt_showInfo);
    }

    void setContentColor(Ref<Protocol::DOM::RGBAColor>&& in_opt_contentColor)
    {
        JSON::ObjectBase::setObject("contentColor"_s, WTFMove(in_opt_contentColor));
    }

    void setPaddingColor(Ref<Protocol::DOM::RGBAColor>&& in_opt_paddingColor)
    {
        JSON::ObjectBase::setObject("paddingColor"_s, WTFMove(in_opt_paddingColor));
    }

    void setBorderColor(Ref<Protocol::DOM::RGBAColor>&& in_opt_borderColor)
    {
        JSON::ObjectBase::setObject("borderColor"_s, WTFMove(in_opt_borderColor));
    }

    void setMarginColor(Ref<Protocol::DOM::RGBAColor>&& in_opt_marginColor)
    {
        JSON::ObjectBase::setObject("marginColor"_s, WTFMove(in_opt_marginColor));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral showInfoKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral contentColorKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral paddingColorKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral borderColorKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral marginColorKey;
};

/* Configuration data for grid overlays. */
class GridOverlayConfig final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        GridColorSet = 1 << 0,
        AllFieldsSet = (GridColorSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*GridOverlayConfig*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class GridOverlayConfig;
    public:

        Builder<STATE | GridColorSet>& setGridColor(Ref<Protocol::DOM::RGBAColor>&& in_gridColor)
        {
            static_assert(!(STATE & GridColorSet), "property gridColor already set");
            m_result->setObject("gridColor"_s, WTFMove(in_gridColor));
            return castState<GridColorSet>();
        }

        Ref<GridOverlayConfig> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(GridOverlayConfig) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<GridOverlayConfig>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<GridOverlayConfig> result = GridOverlayConfig::create()
     *     .setGridColor(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setShowLineNames(bool in_opt_showLineNames)
    {
        JSON::ObjectBase::setBoolean("showLineNames"_s, in_opt_showLineNames);
    }

    void setShowLineNumbers(bool in_opt_showLineNumbers)
    {
        JSON::ObjectBase::setBoolean("showLineNumbers"_s, in_opt_showLineNumbers);
    }

    void setShowExtendedGridLines(bool in_opt_showExtendedGridLines)
    {
        JSON::ObjectBase::setBoolean("showExtendedGridLines"_s, in_opt_showExtendedGridLines);
    }

    void setShowTrackSizes(bool in_opt_showTrackSizes)
    {
        JSON::ObjectBase::setBoolean("showTrackSizes"_s, in_opt_showTrackSizes);
    }

    void setShowAreaNames(bool in_opt_showAreaNames)
    {
        JSON::ObjectBase::setBoolean("showAreaNames"_s, in_opt_showAreaNames);
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral gridColorKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral showLineNamesKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral showLineNumbersKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral showExtendedGridLinesKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral showTrackSizesKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral showAreaNamesKey;
};

/* Configuration data for flex overlays. */
class FlexOverlayConfig final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        FlexColorSet = 1 << 0,
        AllFieldsSet = (FlexColorSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FlexOverlayConfig*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class FlexOverlayConfig;
    public:

        Builder<STATE | FlexColorSet>& setFlexColor(Ref<Protocol::DOM::RGBAColor>&& in_flexColor)
        {
            static_assert(!(STATE & FlexColorSet), "property flexColor already set");
            m_result->setObject("flexColor"_s, WTFMove(in_flexColor));
            return castState<FlexColorSet>();
        }

        Ref<FlexOverlayConfig> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(FlexOverlayConfig) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FlexOverlayConfig>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FlexOverlayConfig> result = FlexOverlayConfig::create()
     *     .setFlexColor(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setShowOrderNumbers(bool in_opt_showOrderNumbers)
    {
        JSON::ObjectBase::setBoolean("showOrderNumbers"_s, in_opt_showOrderNumbers);
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral flexColorKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral showOrderNumbersKey;
};

/* An object referencing a node and a pseudo-element, primarily used to identify an animation effect target. */
class Styleable final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NodeIdSet = 1 << 0,
        AllFieldsSet = (NodeIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Styleable*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Styleable;
    public:

        Builder<STATE | NodeIdSet>& setNodeId(int in_nodeId)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId already set");
            m_result->setInteger("nodeId"_s, in_nodeId);
            return castState<NodeIdSet>();
        }

        Ref<Styleable> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Styleable) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Styleable>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Styleable> result = Styleable::create()
     *     .setNodeId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setPseudoId(Protocol::CSS::PseudoId in_opt_pseudoId)
    {
        JSON::ObjectBase::setString("pseudoId"_s, Protocol::Helpers::getEnumConstantValue(in_opt_pseudoId));
    }
};

/* Data to construct File object. */
class FilePayload final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        TypeSet = 1 << 1,
        DataSet = 1 << 2,
        AllFieldsSet = (NameSet | TypeSet | DataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FilePayload*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class FilePayload;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | TypeSet>& setType(const String& in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, in_type);
            return castState<TypeSet>();
        }

        Builder<STATE | DataSet>& setData(const String& in_data)
        {
            static_assert(!(STATE & DataSet), "property data already set");
            m_result->setString("data"_s, in_data);
            return castState<DataSet>();
        }

        Ref<FilePayload> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(FilePayload) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FilePayload>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FilePayload> result = FilePayload::create()
     *     .setName(...)
     *     .setType(...)
     *     .setData(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // DOM

namespace DOMDebugger {

/* DOM breakpoint type. */
enum class DOMBreakpointType {
    SubtreeModified = 131,
    AttributeModified = 132,
    NodeRemoved = 133,
}; // enum class DOMBreakpointType

/* Event breakpoint type. */
enum class EventBreakpointType {
    AnimationFrame = 134,
    Interval = 135,
    Listener = 136,
    Timeout = 137,
}; // enum class EventBreakpointType

} // DOMDebugger

namespace DOMStorage {

/* DOM Storage identifier. */
class StorageId final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        SecurityOriginSet = 1 << 0,
        IsLocalStorageSet = 1 << 1,
        AllFieldsSet = (SecurityOriginSet | IsLocalStorageSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StorageId*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class StorageId;
    public:

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& in_securityOrigin)
        {
            static_assert(!(STATE & SecurityOriginSet), "property securityOrigin already set");
            m_result->setString("securityOrigin"_s, in_securityOrigin);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | IsLocalStorageSet>& setIsLocalStorage(bool in_isLocalStorage)
        {
            static_assert(!(STATE & IsLocalStorageSet), "property isLocalStorage already set");
            m_result->setBoolean("isLocalStorage"_s, in_isLocalStorage);
            return castState<IsLocalStorageSet>();
        }

        Ref<StorageId> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(StorageId) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StorageId>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StorageId> result = StorageId::create()
     *     .setSecurityOrigin(...)
     *     .setIsLocalStorage(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral securityOriginKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral isLocalStorageKey;
};

} // DOMStorage

namespace Database {

/* Database object. */
class Database final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        DomainSet = 1 << 1,
        NameSet = 1 << 2,
        VersionSet = 1 << 3,
        AllFieldsSet = (IdSet | DomainSet | NameSet | VersionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Database*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Database;
    public:

        Builder<STATE | IdSet>& setId(const String& in_id)
        {
            static_assert(!(STATE & IdSet), "property id already set");
            m_result->setString("id"_s, in_id);
            return castState<IdSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& in_domain)
        {
            static_assert(!(STATE & DomainSet), "property domain already set");
            m_result->setString("domain"_s, in_domain);
            return castState<DomainSet>();
        }

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(const String& in_version)
        {
            static_assert(!(STATE & VersionSet), "property version already set");
            m_result->setString("version"_s, in_version);
            return castState<VersionSet>();
        }

        Ref<Database> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Database) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Database>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Database> result = Database::create()
     *     .setId(...)
     *     .setDomain(...)
     *     .setName(...)
     *     .setVersion(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Database error. */
class Error final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MessageSet = 1 << 0,
        CodeSet = 1 << 1,
        AllFieldsSet = (MessageSet | CodeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Error*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Error;
    public:

        Builder<STATE | MessageSet>& setMessage(const String& in_message)
        {
            static_assert(!(STATE & MessageSet), "property message already set");
            m_result->setString("message"_s, in_message);
            return castState<MessageSet>();
        }

        Builder<STATE | CodeSet>& setCode(int in_code)
        {
            static_assert(!(STATE & CodeSet), "property code already set");
            m_result->setInteger("code"_s, in_code);
            return castState<CodeSet>();
        }

        Ref<Error> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Error) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Error>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Error> result = Error::create()
     *     .setMessage(...)
     *     .setCode(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Database

namespace Debugger {

/* Location in the source code. */
class Location final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        ScriptIdSet = 1 << 0,
        LineNumberSet = 1 << 1,
        AllFieldsSet = (ScriptIdSet | LineNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Location*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Location;
    public:

        Builder<STATE | ScriptIdSet>& setScriptId(const String& in_scriptId)
        {
            static_assert(!(STATE & ScriptIdSet), "property scriptId already set");
            m_result->setString("scriptId"_s, in_scriptId);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int in_lineNumber)
        {
            static_assert(!(STATE & LineNumberSet), "property lineNumber already set");
            m_result->setInteger("lineNumber"_s, in_lineNumber);
            return castState<LineNumberSet>();
        }

        Ref<Location> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Location) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Location>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Location> result = Location::create()
     *     .setScriptId(...)
     *     .setLineNumber(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setColumnNumber(int in_opt_columnNumber)
    {
        JSON::ObjectBase::setInteger("columnNumber"_s, in_opt_columnNumber);
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral scriptIdKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral lineNumberKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral columnNumberKey;
};

/* Action to perform when a breakpoint is triggered. */
class BreakpointAction final : public JSON::Object {
public:
    // Named after property name 'type' while generating BreakpointAction.
    enum class Type {
        Log = 92,
        Evaluate = 138,
        Sound = 139,
        Probe = 140,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BreakpointAction*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class BreakpointAction;
    public:

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<BreakpointAction> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(BreakpointAction) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<BreakpointAction>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BreakpointAction> result = BreakpointAction::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setData(const String& in_opt_data)
    {
        JSON::ObjectBase::setString("data"_s, in_opt_data);
    }

    void setId(int in_opt_id)
    {
        JSON::ObjectBase::setInteger("id"_s, in_opt_id);
    }

    void setEmulateUserGesture(bool in_opt_emulateUserGesture)
    {
        JSON::ObjectBase::setBoolean("emulateUserGesture"_s, in_opt_emulateUserGesture);
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral typeKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral dataKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral idKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral emulateUserGestureKey;
};

/* Extra options that modify breakpoint behavior. */
class BreakpointOptions final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BreakpointOptions*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class BreakpointOptions;
    public:

        Ref<BreakpointOptions> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(BreakpointOptions) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<BreakpointOptions>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BreakpointOptions> result = BreakpointOptions::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setCondition(const String& in_opt_condition)
    {
        JSON::ObjectBase::setString("condition"_s, in_opt_condition);
    }

    void setActions(Ref<JSON::ArrayOf<Protocol::Debugger::BreakpointAction>>&& in_opt_actions)
    {
        JSON::ObjectBase::setArray("actions"_s, WTFMove(in_opt_actions));
    }

    void setAutoContinue(bool in_opt_autoContinue)
    {
        JSON::ObjectBase::setBoolean("autoContinue"_s, in_opt_autoContinue);
    }

    void setIgnoreCount(int in_opt_ignoreCount)
    {
        JSON::ObjectBase::setInteger("ignoreCount"_s, in_opt_ignoreCount);
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral conditionKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral actionsKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral autoContinueKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral ignoreCountKey;
};

/* Information about the function. */
class FunctionDetails final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LocationSet = 1 << 0,
        AllFieldsSet = (LocationSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FunctionDetails*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class FunctionDetails;
    public:

        Builder<STATE | LocationSet>& setLocation(Ref<Protocol::Debugger::Location>&& in_location)
        {
            static_assert(!(STATE & LocationSet), "property location already set");
            m_result->setObject("location"_s, WTFMove(in_location));
            return castState<LocationSet>();
        }

        Ref<FunctionDetails> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(FunctionDetails) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FunctionDetails>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FunctionDetails> result = FunctionDetails::create()
     *     .setLocation(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& in_opt_name)
    {
        JSON::ObjectBase::setString("name"_s, in_opt_name);
    }

    void setDisplayName(const String& in_opt_displayName)
    {
        JSON::ObjectBase::setString("displayName"_s, in_opt_displayName);
    }

    void setScopeChain(Ref<JSON::ArrayOf<Protocol::Debugger::Scope>>&& in_opt_scopeChain)
    {
        JSON::ObjectBase::setArray("scopeChain"_s, WTFMove(in_opt_scopeChain));
    }
};

/* JavaScript call frame. Array of call frames form the call stack. */
class CallFrame final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallFrameIdSet = 1 << 0,
        FunctionNameSet = 1 << 1,
        LocationSet = 1 << 2,
        ScopeChainSet = 1 << 3,
        ThisSet = 1 << 4,
        IsTailDeletedSet = 1 << 5,
        AllFieldsSet = (CallFrameIdSet | FunctionNameSet | LocationSet | ScopeChainSet | ThisSet | IsTailDeletedSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CallFrame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CallFrame;
    public:

        Builder<STATE | CallFrameIdSet>& setCallFrameId(const String& in_callFrameId)
        {
            static_assert(!(STATE & CallFrameIdSet), "property callFrameId already set");
            m_result->setString("callFrameId"_s, in_callFrameId);
            return castState<CallFrameIdSet>();
        }

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& in_functionName)
        {
            static_assert(!(STATE & FunctionNameSet), "property functionName already set");
            m_result->setString("functionName"_s, in_functionName);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | LocationSet>& setLocation(Ref<Protocol::Debugger::Location>&& in_location)
        {
            static_assert(!(STATE & LocationSet), "property location already set");
            m_result->setObject("location"_s, WTFMove(in_location));
            return castState<LocationSet>();
        }

        Builder<STATE | ScopeChainSet>& setScopeChain(Ref<JSON::ArrayOf<Protocol::Debugger::Scope>>&& in_scopeChain)
        {
            static_assert(!(STATE & ScopeChainSet), "property scopeChain already set");
            m_result->setArray("scopeChain"_s, WTFMove(in_scopeChain));
            return castState<ScopeChainSet>();
        }

        Builder<STATE | ThisSet>& setThis(Ref<Protocol::Runtime::RemoteObject>&& in_this)
        {
            static_assert(!(STATE & ThisSet), "property this already set");
            m_result->setObject("this"_s, WTFMove(in_this));
            return castState<ThisSet>();
        }

        Builder<STATE | IsTailDeletedSet>& setIsTailDeleted(bool in_isTailDeleted)
        {
            static_assert(!(STATE & IsTailDeletedSet), "property isTailDeleted already set");
            m_result->setBoolean("isTailDeleted"_s, in_isTailDeleted);
            return castState<IsTailDeletedSet>();
        }

        Ref<CallFrame> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CallFrame) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CallFrame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CallFrame> result = CallFrame::create()
     *     .setCallFrameId(...)
     *     .setFunctionName(...)
     *     .setLocation(...)
     *     .setScopeChain(...)
     *     .setThis(...)
     *     .setIsTailDeleted(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Scope description. */
class Scope final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating Scope.
    enum class Type {
        Global = 141,
        With = 142,
        Closure = 143,
        Catch = 144,
        FunctionName = 145,
        GlobalLexicalEnvironment = 146,
        NestedLexical = 147,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        ObjectSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (ObjectSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Scope*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Scope;
    public:

        Builder<STATE | ObjectSet>& setObject(Ref<Protocol::Runtime::RemoteObject>&& in_object)
        {
            static_assert(!(STATE & ObjectSet), "property object already set");
            m_result->setObject("object"_s, WTFMove(in_object));
            return castState<ObjectSet>();
        }

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<Scope> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Scope) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Scope>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Scope> result = Scope::create()
     *     .setObject(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& in_opt_name)
    {
        JSON::ObjectBase::setString("name"_s, in_opt_name);
    }

    void setLocation(Ref<Protocol::Debugger::Location>&& in_opt_location)
    {
        JSON::ObjectBase::setObject("location"_s, WTFMove(in_opt_location));
    }

    void setEmpty(bool in_opt_empty)
    {
        JSON::ObjectBase::setBoolean("empty"_s, in_opt_empty);
    }
};

/* A sample collected by evaluating a probe breakpoint action. */
class ProbeSample final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ProbeIdSet = 1 << 0,
        SampleIdSet = 1 << 1,
        BatchIdSet = 1 << 2,
        TimestampSet = 1 << 3,
        PayloadSet = 1 << 4,
        AllFieldsSet = (ProbeIdSet | SampleIdSet | BatchIdSet | TimestampSet | PayloadSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ProbeSample*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ProbeSample;
    public:

        Builder<STATE | ProbeIdSet>& setProbeId(int in_probeId)
        {
            static_assert(!(STATE & ProbeIdSet), "property probeId already set");
            m_result->setInteger("probeId"_s, in_probeId);
            return castState<ProbeIdSet>();
        }

        Builder<STATE | SampleIdSet>& setSampleId(int in_sampleId)
        {
            static_assert(!(STATE & SampleIdSet), "property sampleId already set");
            m_result->setInteger("sampleId"_s, in_sampleId);
            return castState<SampleIdSet>();
        }

        Builder<STATE | BatchIdSet>& setBatchId(int in_batchId)
        {
            static_assert(!(STATE & BatchIdSet), "property batchId already set");
            m_result->setInteger("batchId"_s, in_batchId);
            return castState<BatchIdSet>();
        }

        Builder<STATE | TimestampSet>& setTimestamp(double in_timestamp)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp already set");
            m_result->setDouble("timestamp"_s, in_timestamp);
            return castState<TimestampSet>();
        }

        Builder<STATE | PayloadSet>& setPayload(Ref<Protocol::Runtime::RemoteObject>&& in_payload)
        {
            static_assert(!(STATE & PayloadSet), "property payload already set");
            m_result->setObject("payload"_s, WTFMove(in_payload));
            return castState<PayloadSet>();
        }

        Ref<ProbeSample> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ProbeSample) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ProbeSample>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ProbeSample> result = ProbeSample::create()
     *     .setProbeId(...)
     *     .setSampleId(...)
     *     .setBatchId(...)
     *     .setTimestamp(...)
     *     .setPayload(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* The pause reason auxiliary data when paused because of an assertion. */
class AssertPauseReason final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*AssertPauseReason*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class AssertPauseReason;
    public:

        Ref<AssertPauseReason> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(AssertPauseReason) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<AssertPauseReason>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<AssertPauseReason> result = AssertPauseReason::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setMessage(const String& in_opt_message)
    {
        JSON::ObjectBase::setString("message"_s, in_opt_message);
    }
};

/* The pause reason auxiliary data when paused because of hitting a breakpoint. */
class BreakpointPauseReason final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        BreakpointIdSet = 1 << 0,
        AllFieldsSet = (BreakpointIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BreakpointPauseReason*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class BreakpointPauseReason;
    public:

        Builder<STATE | BreakpointIdSet>& setBreakpointId(const String& in_breakpointId)
        {
            static_assert(!(STATE & BreakpointIdSet), "property breakpointId already set");
            m_result->setString("breakpointId"_s, in_breakpointId);
            return castState<BreakpointIdSet>();
        }

        Ref<BreakpointPauseReason> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(BreakpointPauseReason) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<BreakpointPauseReason>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BreakpointPauseReason> result = BreakpointPauseReason::create()
     *     .setBreakpointId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* The pause reason auxiliary data when paused because of a Content Security Policy directive. */
class CSPViolationPauseReason final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DirectiveSet = 1 << 0,
        AllFieldsSet = (DirectiveSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSPViolationPauseReason*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CSPViolationPauseReason;
    public:

        Builder<STATE | DirectiveSet>& setDirective(const String& in_directive)
        {
            static_assert(!(STATE & DirectiveSet), "property directive already set");
            m_result->setString("directive"_s, in_directive);
            return castState<DirectiveSet>();
        }

        Ref<CSPViolationPauseReason> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CSPViolationPauseReason) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CSPViolationPauseReason>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSPViolationPauseReason> result = CSPViolationPauseReason::create()
     *     .setDirective(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Debugger

namespace GenericTypes {

/* Search match in a resource. */
class SearchMatch final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LineNumberSet = 1 << 0,
        LineContentSet = 1 << 1,
        AllFieldsSet = (LineNumberSet | LineContentSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SearchMatch*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class SearchMatch;
    public:

        Builder<STATE | LineNumberSet>& setLineNumber(double in_lineNumber)
        {
            static_assert(!(STATE & LineNumberSet), "property lineNumber already set");
            m_result->setDouble("lineNumber"_s, in_lineNumber);
            return castState<LineNumberSet>();
        }

        Builder<STATE | LineContentSet>& setLineContent(const String& in_lineContent)
        {
            static_assert(!(STATE & LineContentSet), "property lineContent already set");
            m_result->setString("lineContent"_s, in_lineContent);
            return castState<LineContentSet>();
        }

        Ref<SearchMatch> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(SearchMatch) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SearchMatch>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SearchMatch> result = SearchMatch::create()
     *     .setLineNumber(...)
     *     .setLineContent(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // GenericTypes

namespace Heap {

/* Information about a garbage collection. */
class GarbageCollection final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating GarbageCollection.
    enum class Type {
        Full = 148,
        Partial = 149,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        StartTimeSet = 1 << 1,
        EndTimeSet = 1 << 2,
        AllFieldsSet = (TypeSet | StartTimeSet | EndTimeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*GarbageCollection*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class GarbageCollection;
    public:

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Builder<STATE | StartTimeSet>& setStartTime(double in_startTime)
        {
            static_assert(!(STATE & StartTimeSet), "property startTime already set");
            m_result->setDouble("startTime"_s, in_startTime);
            return castState<StartTimeSet>();
        }

        Builder<STATE | EndTimeSet>& setEndTime(double in_endTime)
        {
            static_assert(!(STATE & EndTimeSet), "property endTime already set");
            m_result->setDouble("endTime"_s, in_endTime);
            return castState<EndTimeSet>();
        }

        Ref<GarbageCollection> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(GarbageCollection) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<GarbageCollection>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<GarbageCollection> result = GarbageCollection::create()
     *     .setType(...)
     *     .setStartTime(...)
     *     .setEndTime(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Heap

namespace IndexedDB {

/* Database with an array of object stores. */
class DatabaseWithObjectStores final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        VersionSet = 1 << 1,
        ObjectStoresSet = 1 << 2,
        AllFieldsSet = (NameSet | VersionSet | ObjectStoresSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*DatabaseWithObjectStores*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class DatabaseWithObjectStores;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(double in_version)
        {
            static_assert(!(STATE & VersionSet), "property version already set");
            m_result->setDouble("version"_s, in_version);
            return castState<VersionSet>();
        }

        Builder<STATE | ObjectStoresSet>& setObjectStores(Ref<JSON::ArrayOf<Protocol::IndexedDB::ObjectStore>>&& in_objectStores)
        {
            static_assert(!(STATE & ObjectStoresSet), "property objectStores already set");
            m_result->setArray("objectStores"_s, WTFMove(in_objectStores));
            return castState<ObjectStoresSet>();
        }

        Ref<DatabaseWithObjectStores> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(DatabaseWithObjectStores) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<DatabaseWithObjectStores>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<DatabaseWithObjectStores> result = DatabaseWithObjectStores::create()
     *     .setName(...)
     *     .setVersion(...)
     *     .setObjectStores(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Object store. */
class ObjectStore final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        AutoIncrementSet = 1 << 2,
        IndexesSet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | AutoIncrementSet | IndexesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ObjectStore*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ObjectStore;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(Ref<Protocol::IndexedDB::KeyPath>&& in_keyPath)
        {
            static_assert(!(STATE & KeyPathSet), "property keyPath already set");
            m_result->setObject("keyPath"_s, WTFMove(in_keyPath));
            return castState<KeyPathSet>();
        }

        Builder<STATE | AutoIncrementSet>& setAutoIncrement(bool in_autoIncrement)
        {
            static_assert(!(STATE & AutoIncrementSet), "property autoIncrement already set");
            m_result->setBoolean("autoIncrement"_s, in_autoIncrement);
            return castState<AutoIncrementSet>();
        }

        Builder<STATE | IndexesSet>& setIndexes(Ref<JSON::ArrayOf<Protocol::IndexedDB::ObjectStoreIndex>>&& in_indexes)
        {
            static_assert(!(STATE & IndexesSet), "property indexes already set");
            m_result->setArray("indexes"_s, WTFMove(in_indexes));
            return castState<IndexesSet>();
        }

        Ref<ObjectStore> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ObjectStore) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ObjectStore>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ObjectStore> result = ObjectStore::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setAutoIncrement(...)
     *     .setIndexes(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Object store index. */
class ObjectStoreIndex final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        UniqueSet = 1 << 2,
        MultiEntrySet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | UniqueSet | MultiEntrySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ObjectStoreIndex*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ObjectStoreIndex;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(Ref<Protocol::IndexedDB::KeyPath>&& in_keyPath)
        {
            static_assert(!(STATE & KeyPathSet), "property keyPath already set");
            m_result->setObject("keyPath"_s, WTFMove(in_keyPath));
            return castState<KeyPathSet>();
        }

        Builder<STATE | UniqueSet>& setUnique(bool in_unique)
        {
            static_assert(!(STATE & UniqueSet), "property unique already set");
            m_result->setBoolean("unique"_s, in_unique);
            return castState<UniqueSet>();
        }

        Builder<STATE | MultiEntrySet>& setMultiEntry(bool in_multiEntry)
        {
            static_assert(!(STATE & MultiEntrySet), "property multiEntry already set");
            m_result->setBoolean("multiEntry"_s, in_multiEntry);
            return castState<MultiEntrySet>();
        }

        Ref<ObjectStoreIndex> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ObjectStoreIndex) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ObjectStoreIndex>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ObjectStoreIndex> result = ObjectStoreIndex::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setUnique(...)
     *     .setMultiEntry(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Key. */
class Key final : public JSON::Object {
public:
    // Named after property name 'type' while generating Key.
    enum class Type {
        Number = 150,
        String = 151,
        Date = 125,
        Array = 152,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Key*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Key;
    public:

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<Key> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Key) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Key>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Key> result = Key::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setNumber(double in_opt_number)
    {
        JSON::ObjectBase::setDouble("number"_s, in_opt_number);
    }

    void setString(const String& in_opt_string)
    {
        JSON::ObjectBase::setString("string"_s, in_opt_string);
    }

    void setDate(double in_opt_date)
    {
        JSON::ObjectBase::setDouble("date"_s, in_opt_date);
    }

    void setArray(Ref<JSON::ArrayOf<Protocol::IndexedDB::Key>>&& in_opt_array)
    {
        JSON::ObjectBase::setArray("array"_s, WTFMove(in_opt_array));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral typeKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral numberKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral stringKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral dateKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral arrayKey;
};

/* Key range. */
class KeyRange final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        LowerOpenSet = 1 << 0,
        UpperOpenSet = 1 << 1,
        AllFieldsSet = (LowerOpenSet | UpperOpenSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*KeyRange*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class KeyRange;
    public:

        Builder<STATE | LowerOpenSet>& setLowerOpen(bool in_lowerOpen)
        {
            static_assert(!(STATE & LowerOpenSet), "property lowerOpen already set");
            m_result->setBoolean("lowerOpen"_s, in_lowerOpen);
            return castState<LowerOpenSet>();
        }

        Builder<STATE | UpperOpenSet>& setUpperOpen(bool in_upperOpen)
        {
            static_assert(!(STATE & UpperOpenSet), "property upperOpen already set");
            m_result->setBoolean("upperOpen"_s, in_upperOpen);
            return castState<UpperOpenSet>();
        }

        Ref<KeyRange> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(KeyRange) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<KeyRange>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<KeyRange> result = KeyRange::create()
     *     .setLowerOpen(...)
     *     .setUpperOpen(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setLower(Ref<Protocol::IndexedDB::Key>&& in_opt_lower)
    {
        JSON::ObjectBase::setObject("lower"_s, WTFMove(in_opt_lower));
    }

    void setUpper(Ref<Protocol::IndexedDB::Key>&& in_opt_upper)
    {
        JSON::ObjectBase::setObject("upper"_s, WTFMove(in_opt_upper));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral lowerKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral upperKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral lowerOpenKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral upperOpenKey;
};

/* Data entry. */
class DataEntry final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        KeySet = 1 << 0,
        PrimaryKeySet = 1 << 1,
        ValueSet = 1 << 2,
        AllFieldsSet = (KeySet | PrimaryKeySet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*DataEntry*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class DataEntry;
    public:

        Builder<STATE | KeySet>& setKey(Ref<Protocol::Runtime::RemoteObject>&& in_key)
        {
            static_assert(!(STATE & KeySet), "property key already set");
            m_result->setObject("key"_s, WTFMove(in_key));
            return castState<KeySet>();
        }

        Builder<STATE | PrimaryKeySet>& setPrimaryKey(Ref<Protocol::Runtime::RemoteObject>&& in_primaryKey)
        {
            static_assert(!(STATE & PrimaryKeySet), "property primaryKey already set");
            m_result->setObject("primaryKey"_s, WTFMove(in_primaryKey));
            return castState<PrimaryKeySet>();
        }

        Builder<STATE | ValueSet>& setValue(Ref<Protocol::Runtime::RemoteObject>&& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setObject("value"_s, WTFMove(in_value));
            return castState<ValueSet>();
        }

        Ref<DataEntry> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(DataEntry) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<DataEntry>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<DataEntry> result = DataEntry::create()
     *     .setKey(...)
     *     .setPrimaryKey(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Key path. */
class KeyPath final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating KeyPath.
    enum class Type {
        Null = 153,
        String = 151,
        Array = 152,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*KeyPath*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class KeyPath;
    public:

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<KeyPath> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(KeyPath) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<KeyPath>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<KeyPath> result = KeyPath::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setString(const String& in_opt_string)
    {
        JSON::ObjectBase::setString("string"_s, in_opt_string);
    }

    void setArray(Ref<JSON::ArrayOf<String>>&& in_opt_array)
    {
        JSON::ObjectBase::setArray("array"_s, WTFMove(in_opt_array));
    }
};

} // IndexedDB

namespace LayerTree {

/* A rectangle. */
class IntRect final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        WidthSet = 1 << 2,
        HeightSet = 1 << 3,
        AllFieldsSet = (XSet | YSet | WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*IntRect*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class IntRect;
    public:

        Builder<STATE | XSet>& setX(int in_x)
        {
            static_assert(!(STATE & XSet), "property x already set");
            m_result->setInteger("x"_s, in_x);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(int in_y)
        {
            static_assert(!(STATE & YSet), "property y already set");
            m_result->setInteger("y"_s, in_y);
            return castState<YSet>();
        }

        Builder<STATE | WidthSet>& setWidth(int in_width)
        {
            static_assert(!(STATE & WidthSet), "property width already set");
            m_result->setInteger("width"_s, in_width);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(int in_height)
        {
            static_assert(!(STATE & HeightSet), "property height already set");
            m_result->setInteger("height"_s, in_height);
            return castState<HeightSet>();
        }

        Ref<IntRect> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(IntRect) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<IntRect>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<IntRect> result = IntRect::create()
     *     .setX(...)
     *     .setY(...)
     *     .setWidth(...)
     *     .setHeight(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Information about a compositing layer. */
class Layer final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LayerIdSet = 1 << 0,
        NodeIdSet = 1 << 1,
        BoundsSet = 1 << 2,
        PaintCountSet = 1 << 3,
        MemorySet = 1 << 4,
        CompositedBoundsSet = 1 << 5,
        AllFieldsSet = (LayerIdSet | NodeIdSet | BoundsSet | PaintCountSet | MemorySet | CompositedBoundsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Layer*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Layer;
    public:

        Builder<STATE | LayerIdSet>& setLayerId(const String& in_layerId)
        {
            static_assert(!(STATE & LayerIdSet), "property layerId already set");
            m_result->setString("layerId"_s, in_layerId);
            return castState<LayerIdSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int in_nodeId)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId already set");
            m_result->setInteger("nodeId"_s, in_nodeId);
            return castState<NodeIdSet>();
        }

        Builder<STATE | BoundsSet>& setBounds(Ref<Protocol::LayerTree::IntRect>&& in_bounds)
        {
            static_assert(!(STATE & BoundsSet), "property bounds already set");
            m_result->setObject("bounds"_s, WTFMove(in_bounds));
            return castState<BoundsSet>();
        }

        Builder<STATE | PaintCountSet>& setPaintCount(int in_paintCount)
        {
            static_assert(!(STATE & PaintCountSet), "property paintCount already set");
            m_result->setInteger("paintCount"_s, in_paintCount);
            return castState<PaintCountSet>();
        }

        Builder<STATE | MemorySet>& setMemory(int in_memory)
        {
            static_assert(!(STATE & MemorySet), "property memory already set");
            m_result->setInteger("memory"_s, in_memory);
            return castState<MemorySet>();
        }

        Builder<STATE | CompositedBoundsSet>& setCompositedBounds(Ref<Protocol::LayerTree::IntRect>&& in_compositedBounds)
        {
            static_assert(!(STATE & CompositedBoundsSet), "property compositedBounds already set");
            m_result->setObject("compositedBounds"_s, WTFMove(in_compositedBounds));
            return castState<CompositedBoundsSet>();
        }

        Ref<Layer> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Layer) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Layer>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Layer> result = Layer::create()
     *     .setLayerId(...)
     *     .setNodeId(...)
     *     .setBounds(...)
     *     .setPaintCount(...)
     *     .setMemory(...)
     *     .setCompositedBounds(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setIsInShadowTree(bool in_opt_isInShadowTree)
    {
        JSON::ObjectBase::setBoolean("isInShadowTree"_s, in_opt_isInShadowTree);
    }

    void setIsReflection(bool in_opt_isReflection)
    {
        JSON::ObjectBase::setBoolean("isReflection"_s, in_opt_isReflection);
    }

    void setIsGeneratedContent(bool in_opt_isGeneratedContent)
    {
        JSON::ObjectBase::setBoolean("isGeneratedContent"_s, in_opt_isGeneratedContent);
    }

    void setIsAnonymous(bool in_opt_isAnonymous)
    {
        JSON::ObjectBase::setBoolean("isAnonymous"_s, in_opt_isAnonymous);
    }

    void setPseudoElementId(const String& in_opt_pseudoElementId)
    {
        JSON::ObjectBase::setString("pseudoElementId"_s, in_opt_pseudoElementId);
    }

    void setPseudoElement(const String& in_opt_pseudoElement)
    {
        JSON::ObjectBase::setString("pseudoElement"_s, in_opt_pseudoElement);
    }
};

/* An object containing the reasons why the layer was composited as properties. */
class CompositingReasons final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CompositingReasons*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CompositingReasons;
    public:

        Ref<CompositingReasons> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CompositingReasons) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CompositingReasons>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CompositingReasons> result = CompositingReasons::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setTransform3D(bool in_opt_transform3D)
    {
        JSON::ObjectBase::setBoolean("transform3D"_s, in_opt_transform3D);
    }

    void setVideo(bool in_opt_video)
    {
        JSON::ObjectBase::setBoolean("video"_s, in_opt_video);
    }

    void setCanvas(bool in_opt_canvas)
    {
        JSON::ObjectBase::setBoolean("canvas"_s, in_opt_canvas);
    }

    void setPlugin(bool in_opt_plugin)
    {
        JSON::ObjectBase::setBoolean("plugin"_s, in_opt_plugin);
    }

    void setIFrame(bool in_opt_iFrame)
    {
        JSON::ObjectBase::setBoolean("iFrame"_s, in_opt_iFrame);
    }

    void setModel(bool in_opt_model)
    {
        JSON::ObjectBase::setBoolean("model"_s, in_opt_model);
    }

    void setBackfaceVisibilityHidden(bool in_opt_backfaceVisibilityHidden)
    {
        JSON::ObjectBase::setBoolean("backfaceVisibilityHidden"_s, in_opt_backfaceVisibilityHidden);
    }

    void setClipsCompositingDescendants(bool in_opt_clipsCompositingDescendants)
    {
        JSON::ObjectBase::setBoolean("clipsCompositingDescendants"_s, in_opt_clipsCompositingDescendants);
    }

    void setAnimation(bool in_opt_animation)
    {
        JSON::ObjectBase::setBoolean("animation"_s, in_opt_animation);
    }

    void setFilters(bool in_opt_filters)
    {
        JSON::ObjectBase::setBoolean("filters"_s, in_opt_filters);
    }

    void setPositionFixed(bool in_opt_positionFixed)
    {
        JSON::ObjectBase::setBoolean("positionFixed"_s, in_opt_positionFixed);
    }

    void setPositionSticky(bool in_opt_positionSticky)
    {
        JSON::ObjectBase::setBoolean("positionSticky"_s, in_opt_positionSticky);
    }

    void setOverflowScrollingTouch(bool in_opt_overflowScrollingTouch)
    {
        JSON::ObjectBase::setBoolean("overflowScrollingTouch"_s, in_opt_overflowScrollingTouch);
    }

    void setStacking(bool in_opt_stacking)
    {
        JSON::ObjectBase::setBoolean("stacking"_s, in_opt_stacking);
    }

    void setOverlap(bool in_opt_overlap)
    {
        JSON::ObjectBase::setBoolean("overlap"_s, in_opt_overlap);
    }

    void setNegativeZIndexChildren(bool in_opt_negativeZIndexChildren)
    {
        JSON::ObjectBase::setBoolean("negativeZIndexChildren"_s, in_opt_negativeZIndexChildren);
    }

    void setTransformWithCompositedDescendants(bool in_opt_transformWithCompositedDescendants)
    {
        JSON::ObjectBase::setBoolean("transformWithCompositedDescendants"_s, in_opt_transformWithCompositedDescendants);
    }

    void setOpacityWithCompositedDescendants(bool in_opt_opacityWithCompositedDescendants)
    {
        JSON::ObjectBase::setBoolean("opacityWithCompositedDescendants"_s, in_opt_opacityWithCompositedDescendants);
    }

    void setMaskWithCompositedDescendants(bool in_opt_maskWithCompositedDescendants)
    {
        JSON::ObjectBase::setBoolean("maskWithCompositedDescendants"_s, in_opt_maskWithCompositedDescendants);
    }

    void setReflectionWithCompositedDescendants(bool in_opt_reflectionWithCompositedDescendants)
    {
        JSON::ObjectBase::setBoolean("reflectionWithCompositedDescendants"_s, in_opt_reflectionWithCompositedDescendants);
    }

    void setFilterWithCompositedDescendants(bool in_opt_filterWithCompositedDescendants)
    {
        JSON::ObjectBase::setBoolean("filterWithCompositedDescendants"_s, in_opt_filterWithCompositedDescendants);
    }

    void setBlendingWithCompositedDescendants(bool in_opt_blendingWithCompositedDescendants)
    {
        JSON::ObjectBase::setBoolean("blendingWithCompositedDescendants"_s, in_opt_blendingWithCompositedDescendants);
    }

    void setIsolatesCompositedBlendingDescendants(bool in_opt_isolatesCompositedBlendingDescendants)
    {
        JSON::ObjectBase::setBoolean("isolatesCompositedBlendingDescendants"_s, in_opt_isolatesCompositedBlendingDescendants);
    }

    void setPerspective(bool in_opt_perspective)
    {
        JSON::ObjectBase::setBoolean("perspective"_s, in_opt_perspective);
    }

    void setPreserve3D(bool in_opt_preserve3D)
    {
        JSON::ObjectBase::setBoolean("preserve3D"_s, in_opt_preserve3D);
    }

    void setWillChange(bool in_opt_willChange)
    {
        JSON::ObjectBase::setBoolean("willChange"_s, in_opt_willChange);
    }

    void setRoot(bool in_opt_root)
    {
        JSON::ObjectBase::setBoolean("root"_s, in_opt_root);
    }

    void setBlending(bool in_opt_blending)
    {
        JSON::ObjectBase::setBoolean("blending"_s, in_opt_blending);
    }
};

} // LayerTree

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
namespace Memory {

class Event final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TimestampSet = 1 << 0,
        CategoriesSet = 1 << 1,
        AllFieldsSet = (TimestampSet | CategoriesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Event*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Event;
    public:

        Builder<STATE | TimestampSet>& setTimestamp(double in_timestamp)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp already set");
            m_result->setDouble("timestamp"_s, in_timestamp);
            return castState<TimestampSet>();
        }

        Builder<STATE | CategoriesSet>& setCategories(Ref<JSON::ArrayOf<Protocol::Memory::CategoryData>>&& in_categories)
        {
            static_assert(!(STATE & CategoriesSet), "property categories already set");
            m_result->setArray("categories"_s, WTFMove(in_categories));
            return castState<CategoriesSet>();
        }

        Ref<Event> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Event) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Event>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Event> result = Event::create()
     *     .setTimestamp(...)
     *     .setCategories(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class CategoryData final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating CategoryData.
    enum class Type {
        JavaScript = 72,
        JIT = 154,
        Images = 155,
        Layers = 156,
        Page = 122,
        Other = 87,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        SizeSet = 1 << 1,
        AllFieldsSet = (TypeSet | SizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CategoryData*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CategoryData;
    public:

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Builder<STATE | SizeSet>& setSize(double in_size)
        {
            static_assert(!(STATE & SizeSet), "property size already set");
            m_result->setDouble("size"_s, in_size);
            return castState<SizeSet>();
        }

        Ref<CategoryData> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CategoryData) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CategoryData>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CategoryData> result = CategoryData::create()
     *     .setType(...)
     *     .setSize(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Memory
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

namespace Network {

/* Controls how much referrer information is sent with the request */
enum class ReferrerPolicy {
    EmptyString = 157,
    NoReferrer = 158,
    NoReferrerWhenDowngrade = 159,
    SameOrigin = 160,
    Origin = 161,
    StrictOrigin = 162,
    OriginWhenCrossOrigin = 163,
    StrictOriginWhenCrossOrigin = 164,
    UnsafeUrl = 165,
}; // enum class ReferrerPolicy

/* Request / response headers as keys / values of JSON object. */
class Headers final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Headers*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Headers;
    public:

        Ref<Headers> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Headers) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Headers>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Headers> result = Headers::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Timing information for the request. */
class ResourceTiming final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartTimeSet = 1 << 0,
        RedirectStartSet = 1 << 1,
        RedirectEndSet = 1 << 2,
        FetchStartSet = 1 << 3,
        DomainLookupStartSet = 1 << 4,
        DomainLookupEndSet = 1 << 5,
        ConnectStartSet = 1 << 6,
        ConnectEndSet = 1 << 7,
        SecureConnectionStartSet = 1 << 8,
        RequestStartSet = 1 << 9,
        ResponseStartSet = 1 << 10,
        ResponseEndSet = 1 << 11,
        AllFieldsSet = (StartTimeSet | RedirectStartSet | RedirectEndSet | FetchStartSet | DomainLookupStartSet | DomainLookupEndSet | ConnectStartSet | ConnectEndSet | SecureConnectionStartSet | RequestStartSet | ResponseStartSet | ResponseEndSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ResourceTiming*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ResourceTiming;
    public:

        Builder<STATE | StartTimeSet>& setStartTime(double in_startTime)
        {
            static_assert(!(STATE & StartTimeSet), "property startTime already set");
            m_result->setDouble("startTime"_s, in_startTime);
            return castState<StartTimeSet>();
        }

        Builder<STATE | RedirectStartSet>& setRedirectStart(double in_redirectStart)
        {
            static_assert(!(STATE & RedirectStartSet), "property redirectStart already set");
            m_result->setDouble("redirectStart"_s, in_redirectStart);
            return castState<RedirectStartSet>();
        }

        Builder<STATE | RedirectEndSet>& setRedirectEnd(double in_redirectEnd)
        {
            static_assert(!(STATE & RedirectEndSet), "property redirectEnd already set");
            m_result->setDouble("redirectEnd"_s, in_redirectEnd);
            return castState<RedirectEndSet>();
        }

        Builder<STATE | FetchStartSet>& setFetchStart(double in_fetchStart)
        {
            static_assert(!(STATE & FetchStartSet), "property fetchStart already set");
            m_result->setDouble("fetchStart"_s, in_fetchStart);
            return castState<FetchStartSet>();
        }

        Builder<STATE | DomainLookupStartSet>& setDomainLookupStart(double in_domainLookupStart)
        {
            static_assert(!(STATE & DomainLookupStartSet), "property domainLookupStart already set");
            m_result->setDouble("domainLookupStart"_s, in_domainLookupStart);
            return castState<DomainLookupStartSet>();
        }

        Builder<STATE | DomainLookupEndSet>& setDomainLookupEnd(double in_domainLookupEnd)
        {
            static_assert(!(STATE & DomainLookupEndSet), "property domainLookupEnd already set");
            m_result->setDouble("domainLookupEnd"_s, in_domainLookupEnd);
            return castState<DomainLookupEndSet>();
        }

        Builder<STATE | ConnectStartSet>& setConnectStart(double in_connectStart)
        {
            static_assert(!(STATE & ConnectStartSet), "property connectStart already set");
            m_result->setDouble("connectStart"_s, in_connectStart);
            return castState<ConnectStartSet>();
        }

        Builder<STATE | ConnectEndSet>& setConnectEnd(double in_connectEnd)
        {
            static_assert(!(STATE & ConnectEndSet), "property connectEnd already set");
            m_result->setDouble("connectEnd"_s, in_connectEnd);
            return castState<ConnectEndSet>();
        }

        Builder<STATE | SecureConnectionStartSet>& setSecureConnectionStart(double in_secureConnectionStart)
        {
            static_assert(!(STATE & SecureConnectionStartSet), "property secureConnectionStart already set");
            m_result->setDouble("secureConnectionStart"_s, in_secureConnectionStart);
            return castState<SecureConnectionStartSet>();
        }

        Builder<STATE | RequestStartSet>& setRequestStart(double in_requestStart)
        {
            static_assert(!(STATE & RequestStartSet), "property requestStart already set");
            m_result->setDouble("requestStart"_s, in_requestStart);
            return castState<RequestStartSet>();
        }

        Builder<STATE | ResponseStartSet>& setResponseStart(double in_responseStart)
        {
            static_assert(!(STATE & ResponseStartSet), "property responseStart already set");
            m_result->setDouble("responseStart"_s, in_responseStart);
            return castState<ResponseStartSet>();
        }

        Builder<STATE | ResponseEndSet>& setResponseEnd(double in_responseEnd)
        {
            static_assert(!(STATE & ResponseEndSet), "property responseEnd already set");
            m_result->setDouble("responseEnd"_s, in_responseEnd);
            return castState<ResponseEndSet>();
        }

        Ref<ResourceTiming> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ResourceTiming) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ResourceTiming>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ResourceTiming> result = ResourceTiming::create()
     *     .setStartTime(...)
     *     .setRedirectStart(...)
     *     .setRedirectEnd(...)
     *     .setFetchStart(...)
     *     .setDomainLookupStart(...)
     *     .setDomainLookupEnd(...)
     *     .setConnectStart(...)
     *     .setConnectEnd(...)
     *     .setSecureConnectionStart(...)
     *     .setRequestStart(...)
     *     .setResponseStart(...)
     *     .setResponseEnd(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* HTTP request data. */
class Request final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        MethodSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (UrlSet | MethodSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Request*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Request;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | MethodSet>& setMethod(const String& in_method)
        {
            static_assert(!(STATE & MethodSet), "property method already set");
            m_result->setString("method"_s, in_method);
            return castState<MethodSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(Ref<Protocol::Network::Headers>&& in_headers)
        {
            static_assert(!(STATE & HeadersSet), "property headers already set");
            m_result->setObject("headers"_s, WTFMove(in_headers));
            return castState<HeadersSet>();
        }

        Ref<Request> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Request) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Request>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Request> result = Request::create()
     *     .setUrl(...)
     *     .setMethod(...)
     *     .setHeaders(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setPostData(const String& in_opt_postData)
    {
        JSON::ObjectBase::setString("postData"_s, in_opt_postData);
    }

    void setReferrerPolicy(Protocol::Network::ReferrerPolicy in_opt_referrerPolicy)
    {
        JSON::ObjectBase::setString("referrerPolicy"_s, Protocol::Helpers::getEnumConstantValue(in_opt_referrerPolicy));
    }

    void setIntegrity(const String& in_opt_integrity)
    {
        JSON::ObjectBase::setString("integrity"_s, in_opt_integrity);
    }
};

/* HTTP response data. */
class Response final : public JSON::Object {
public:
    // Named after property name 'source' while generating Response.
    enum class Source {
        Unknown = 166,
        Network = 73,
        MemoryCache = 167,
        DiskCache = 168,
        ServiceWorker = 169,
        InspectorOverride = 170,
    }; // enum class Source

    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        StatusSet = 1 << 1,
        StatusTextSet = 1 << 2,
        HeadersSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        SourceSet = 1 << 5,
        AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | MimeTypeSet | SourceSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Response*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Response;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | StatusSet>& setStatus(int in_status)
        {
            static_assert(!(STATE & StatusSet), "property status already set");
            m_result->setInteger("status"_s, in_status);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& in_statusText)
        {
            static_assert(!(STATE & StatusTextSet), "property statusText already set");
            m_result->setString("statusText"_s, in_statusText);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(Ref<Protocol::Network::Headers>&& in_headers)
        {
            static_assert(!(STATE & HeadersSet), "property headers already set");
            m_result->setObject("headers"_s, WTFMove(in_headers));
            return castState<HeadersSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& in_mimeType)
        {
            static_assert(!(STATE & MimeTypeSet), "property mimeType already set");
            m_result->setString("mimeType"_s, in_mimeType);
            return castState<MimeTypeSet>();
        }

        Builder<STATE | SourceSet>& setSource(Source in_source)
        {
            static_assert(!(STATE & SourceSet), "property source already set");
            m_result->setString("source"_s, Protocol::Helpers::getEnumConstantValue(in_source));
            return castState<SourceSet>();
        }

        Ref<Response> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Response) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Response>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Response> result = Response::create()
     *     .setUrl(...)
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...)
     *     .setMimeType(...)
     *     .setSource(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setRequestHeaders(Ref<Protocol::Network::Headers>&& in_opt_requestHeaders)
    {
        JSON::ObjectBase::setObject("requestHeaders"_s, WTFMove(in_opt_requestHeaders));
    }

    void setTiming(Ref<Protocol::Network::ResourceTiming>&& in_opt_timing)
    {
        JSON::ObjectBase::setObject("timing"_s, WTFMove(in_opt_timing));
    }

    void setSecurity(Ref<Protocol::Security::Security>&& in_opt_security)
    {
        JSON::ObjectBase::setObject("security"_s, WTFMove(in_opt_security));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral statusKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral statusTextKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral mimeTypeKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral sourceKey;
};

/* Network load metrics. */
class Metrics final : public JSON::ObjectBase {
public:
    // Named after property name 'priority' while generating Metrics.
    enum class Priority {
        Low = 171,
        Medium = 172,
        High = 173,
    }; // enum class Priority

    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Metrics*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Metrics;
    public:

        Ref<Metrics> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Metrics) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Metrics>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Metrics> result = Metrics::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setProtocol(const String& in_opt_protocol)
    {
        JSON::ObjectBase::setString("protocol"_s, in_opt_protocol);
    }

    void setPriority(Priority in_opt_priority)
    {
        JSON::ObjectBase::setString("priority"_s, Protocol::Helpers::getEnumConstantValue(in_opt_priority));
    }

    void setConnectionIdentifier(const String& in_opt_connectionIdentifier)
    {
        JSON::ObjectBase::setString("connectionIdentifier"_s, in_opt_connectionIdentifier);
    }

    void setRemoteAddress(const String& in_opt_remoteAddress)
    {
        JSON::ObjectBase::setString("remoteAddress"_s, in_opt_remoteAddress);
    }

    void setRequestHeaders(Ref<Protocol::Network::Headers>&& in_opt_requestHeaders)
    {
        JSON::ObjectBase::setObject("requestHeaders"_s, WTFMove(in_opt_requestHeaders));
    }

    void setRequestHeaderBytesSent(double in_opt_requestHeaderBytesSent)
    {
        JSON::ObjectBase::setDouble("requestHeaderBytesSent"_s, in_opt_requestHeaderBytesSent);
    }

    void setRequestBodyBytesSent(double in_opt_requestBodyBytesSent)
    {
        JSON::ObjectBase::setDouble("requestBodyBytesSent"_s, in_opt_requestBodyBytesSent);
    }

    void setResponseHeaderBytesReceived(double in_opt_responseHeaderBytesReceived)
    {
        JSON::ObjectBase::setDouble("responseHeaderBytesReceived"_s, in_opt_responseHeaderBytesReceived);
    }

    void setResponseBodyBytesReceived(double in_opt_responseBodyBytesReceived)
    {
        JSON::ObjectBase::setDouble("responseBodyBytesReceived"_s, in_opt_responseBodyBytesReceived);
    }

    void setResponseBodyDecodedSize(double in_opt_responseBodyDecodedSize)
    {
        JSON::ObjectBase::setDouble("responseBodyDecodedSize"_s, in_opt_responseBodyDecodedSize);
    }

    void setSecurityConnection(Ref<Protocol::Security::Connection>&& in_opt_securityConnection)
    {
        JSON::ObjectBase::setObject("securityConnection"_s, WTFMove(in_opt_securityConnection));
    }

    void setIsProxyConnection(bool in_opt_isProxyConnection)
    {
        JSON::ObjectBase::setBoolean("isProxyConnection"_s, in_opt_isProxyConnection);
    }
};

/* WebSocket request data. */
class WebSocketRequest final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        HeadersSet = 1 << 0,
        AllFieldsSet = (HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*WebSocketRequest*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class WebSocketRequest;
    public:

        Builder<STATE | HeadersSet>& setHeaders(Ref<Protocol::Network::Headers>&& in_headers)
        {
            static_assert(!(STATE & HeadersSet), "property headers already set");
            m_result->setObject("headers"_s, WTFMove(in_headers));
            return castState<HeadersSet>();
        }

        Ref<WebSocketRequest> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(WebSocketRequest) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<WebSocketRequest>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<WebSocketRequest> result = WebSocketRequest::create()
     *     .setHeaders(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* WebSocket response data. */
class WebSocketResponse final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StatusSet = 1 << 0,
        StatusTextSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (StatusSet | StatusTextSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*WebSocketResponse*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class WebSocketResponse;
    public:

        Builder<STATE | StatusSet>& setStatus(int in_status)
        {
            static_assert(!(STATE & StatusSet), "property status already set");
            m_result->setInteger("status"_s, in_status);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& in_statusText)
        {
            static_assert(!(STATE & StatusTextSet), "property statusText already set");
            m_result->setString("statusText"_s, in_statusText);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(Ref<Protocol::Network::Headers>&& in_headers)
        {
            static_assert(!(STATE & HeadersSet), "property headers already set");
            m_result->setObject("headers"_s, WTFMove(in_headers));
            return castState<HeadersSet>();
        }

        Ref<WebSocketResponse> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(WebSocketResponse) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<WebSocketResponse>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<WebSocketResponse> result = WebSocketResponse::create()
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* WebSocket frame data. */
class WebSocketFrame final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        OpcodeSet = 1 << 0,
        MaskSet = 1 << 1,
        PayloadDataSet = 1 << 2,
        PayloadLengthSet = 1 << 3,
        AllFieldsSet = (OpcodeSet | MaskSet | PayloadDataSet | PayloadLengthSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*WebSocketFrame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class WebSocketFrame;
    public:

        Builder<STATE | OpcodeSet>& setOpcode(double in_opcode)
        {
            static_assert(!(STATE & OpcodeSet), "property opcode already set");
            m_result->setDouble("opcode"_s, in_opcode);
            return castState<OpcodeSet>();
        }

        Builder<STATE | MaskSet>& setMask(bool in_mask)
        {
            static_assert(!(STATE & MaskSet), "property mask already set");
            m_result->setBoolean("mask"_s, in_mask);
            return castState<MaskSet>();
        }

        Builder<STATE | PayloadDataSet>& setPayloadData(const String& in_payloadData)
        {
            static_assert(!(STATE & PayloadDataSet), "property payloadData already set");
            m_result->setString("payloadData"_s, in_payloadData);
            return castState<PayloadDataSet>();
        }

        Builder<STATE | PayloadLengthSet>& setPayloadLength(double in_payloadLength)
        {
            static_assert(!(STATE & PayloadLengthSet), "property payloadLength already set");
            m_result->setDouble("payloadLength"_s, in_payloadLength);
            return castState<PayloadLengthSet>();
        }

        Ref<WebSocketFrame> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(WebSocketFrame) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<WebSocketFrame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<WebSocketFrame> result = WebSocketFrame::create()
     *     .setOpcode(...)
     *     .setMask(...)
     *     .setPayloadData(...)
     *     .setPayloadLength(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Information about the cached resource. */
class CachedResource final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        TypeSet = 1 << 1,
        BodySizeSet = 1 << 2,
        AllFieldsSet = (UrlSet | TypeSet | BodySizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CachedResource*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CachedResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | TypeSet>& setType(Protocol::Page::ResourceType in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Builder<STATE | BodySizeSet>& setBodySize(double in_bodySize)
        {
            static_assert(!(STATE & BodySizeSet), "property bodySize already set");
            m_result->setDouble("bodySize"_s, in_bodySize);
            return castState<BodySizeSet>();
        }

        Ref<CachedResource> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CachedResource) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CachedResource>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CachedResource> result = CachedResource::create()
     *     .setUrl(...)
     *     .setType(...)
     *     .setBodySize(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setResponse(Ref<Protocol::Network::Response>&& in_opt_response)
    {
        JSON::ObjectBase::setObject("response"_s, WTFMove(in_opt_response));
    }

    void setSourceMapURL(const String& in_opt_sourceMapURL)
    {
        JSON::ObjectBase::setString("sourceMapURL"_s, in_opt_sourceMapURL);
    }
};

/* Information about the request initiator. */
class Initiator final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating Initiator.
    enum class Type {
        Parser = 186,
        Script = 187,
        Other = 87,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Initiator*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Initiator;
    public:

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<Initiator> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Initiator) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Initiator>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Initiator> result = Initiator::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setStackTrace(Ref<Protocol::Console::StackTrace>&& in_opt_stackTrace)
    {
        JSON::ObjectBase::setObject("stackTrace"_s, WTFMove(in_opt_stackTrace));
    }

    void setUrl(const String& in_opt_url)
    {
        JSON::ObjectBase::setString("url"_s, in_opt_url);
    }

    void setLineNumber(double in_opt_lineNumber)
    {
        JSON::ObjectBase::setDouble("lineNumber"_s, in_opt_lineNumber);
    }

    void setNodeId(int in_opt_nodeId)
    {
        JSON::ObjectBase::setInteger("nodeId"_s, in_opt_nodeId);
    }
};

/* Different stages of a network request. */
enum class NetworkStage {
    Request = 188,
    Response = 189,
}; // enum class NetworkStage

/* Different stages of a network request. */
enum class ResourceErrorType {
    General = 190,
    AccessControl = 191,
    Cancellation = 192,
    Timeout = 193,
}; // enum class ResourceErrorType

} // Network

namespace Page {

/* List of settings able to be overridden by WebInspector. */
enum class Setting {
    PrivateClickMeasurementDebugModeEnabled = 194,
    AuthorAndUserStylesEnabled = 195,
    ICECandidateFilteringEnabled = 196,
    ITPDebugModeEnabled = 197,
    ImagesEnabled = 198,
    MediaCaptureRequiresSecureConnection = 199,
    MockCaptureDevicesEnabled = 200,
    NeedsSiteSpecificQuirks = 201,
    ScriptEnabled = 202,
    ShowDebugBorders = 203,
    ShowRepaintCounter = 204,
    WebSecurityEnabled = 205,
    DeviceOrientationEventEnabled = 206,
    SpeechRecognitionEnabled = 207,
    PointerLockEnabled = 208,
    NotificationsEnabled = 209,
    FullScreenEnabled = 210,
    InputTypeMonthEnabled = 211,
    InputTypeWeekEnabled = 212,
}; // enum class Setting

/* A user preference that can be overriden by Web Inspector, like an accessibility preference. */
class UserPreference final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*UserPreference*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class UserPreference;
    public:

        Builder<STATE | NameSet>& setName(Protocol::Page::UserPreferenceName in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, Protocol::Helpers::getEnumConstantValue(in_name));
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(Protocol::Page::UserPreferenceValue in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, Protocol::Helpers::getEnumConstantValue(in_value));
            return castState<ValueSet>();
        }

        Ref<UserPreference> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(UserPreference) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<UserPreference>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<UserPreference> result = UserPreference::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* User preference name. */
enum class UserPreferenceName {
    PrefersReducedMotion = 213,
    PrefersContrast = 214,
    PrefersColorScheme = 215,
}; // enum class UserPreferenceName

/* User preference value. */
enum class UserPreferenceValue {
    NoPreference = 216,
    Reduce = 217,
    More = 218,
    Light = 219,
    Dark = 220,
}; // enum class UserPreferenceValue

/* Resource type as it was perceived by the rendering engine. */
enum class ResourceType {
    Document = 174,
    StyleSheet = 175,
    Image = 176,
    Font = 177,
    Script = 178,
    XHR = 179,
    Fetch = 180,
    Ping = 181,
    Beacon = 182,
    WebSocket = 183,
    EventSource = 184,
    Other = 185,
}; // enum class ResourceType

/* Coordinate system used by supplied coordinates. */
enum class CoordinateSystem {
    Viewport = 221,
    Page = 222,
}; // enum class CoordinateSystem

/* Same-Site policy of a cookie. */
enum class CookieSameSitePolicy {
    None = 223,
    Lax = 224,
    Strict = 225,
}; // enum class CookieSameSitePolicy

/* Page forced-colors media query override. */
enum class ForcedColors {
    Active = 226,
    None = 223,
}; // enum class ForcedColors

/* Information about the Frame on the page. */
class Frame final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        LoaderIdSet = 1 << 1,
        UrlSet = 1 << 2,
        SecurityOriginSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        AllFieldsSet = (IdSet | LoaderIdSet | UrlSet | SecurityOriginSet | MimeTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Frame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Frame;
    public:

        Builder<STATE | IdSet>& setId(const String& in_id)
        {
            static_assert(!(STATE & IdSet), "property id already set");
            m_result->setString("id"_s, in_id);
            return castState<IdSet>();
        }

        Builder<STATE | LoaderIdSet>& setLoaderId(const String& in_loaderId)
        {
            static_assert(!(STATE & LoaderIdSet), "property loaderId already set");
            m_result->setString("loaderId"_s, in_loaderId);
            return castState<LoaderIdSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& in_securityOrigin)
        {
            static_assert(!(STATE & SecurityOriginSet), "property securityOrigin already set");
            m_result->setString("securityOrigin"_s, in_securityOrigin);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& in_mimeType)
        {
            static_assert(!(STATE & MimeTypeSet), "property mimeType already set");
            m_result->setString("mimeType"_s, in_mimeType);
            return castState<MimeTypeSet>();
        }

        Ref<Frame> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Frame) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Frame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Frame> result = Frame::create()
     *     .setId(...)
     *     .setLoaderId(...)
     *     .setUrl(...)
     *     .setSecurityOrigin(...)
     *     .setMimeType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setParentId(const String& in_opt_parentId)
    {
        JSON::ObjectBase::setString("parentId"_s, in_opt_parentId);
    }

    void setName(const String& in_opt_name)
    {
        JSON::ObjectBase::setString("name"_s, in_opt_name);
    }
};

class FrameResource final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        TypeSet = 1 << 1,
        MimeTypeSet = 1 << 2,
        AllFieldsSet = (UrlSet | TypeSet | MimeTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FrameResource*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class FrameResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | TypeSet>& setType(Protocol::Page::ResourceType in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& in_mimeType)
        {
            static_assert(!(STATE & MimeTypeSet), "property mimeType already set");
            m_result->setString("mimeType"_s, in_mimeType);
            return castState<MimeTypeSet>();
        }

        Ref<FrameResource> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(FrameResource) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FrameResource>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FrameResource> result = FrameResource::create()
     *     .setUrl(...)
     *     .setType(...)
     *     .setMimeType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setFailed(bool in_opt_failed)
    {
        JSON::ObjectBase::setBoolean("failed"_s, in_opt_failed);
    }

    void setCanceled(bool in_opt_canceled)
    {
        JSON::ObjectBase::setBoolean("canceled"_s, in_opt_canceled);
    }

    void setSourceMapURL(const String& in_opt_sourceMapURL)
    {
        JSON::ObjectBase::setString("sourceMapURL"_s, in_opt_sourceMapURL);
    }

    void setTargetId(const String& in_opt_targetId)
    {
        JSON::ObjectBase::setString("targetId"_s, in_opt_targetId);
    }
};

/* Information about the Frame hierarchy along with their cached resources. */
class FrameResourceTree final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FrameSet = 1 << 0,
        ResourcesSet = 1 << 1,
        AllFieldsSet = (FrameSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FrameResourceTree*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class FrameResourceTree;
    public:

        Builder<STATE | FrameSet>& setFrame(Ref<Protocol::Page::Frame>&& in_frame)
        {
            static_assert(!(STATE & FrameSet), "property frame already set");
            m_result->setObject("frame"_s, WTFMove(in_frame));
            return castState<FrameSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(Ref<JSON::ArrayOf<Protocol::Page::FrameResource>>&& in_resources)
        {
            static_assert(!(STATE & ResourcesSet), "property resources already set");
            m_result->setArray("resources"_s, WTFMove(in_resources));
            return castState<ResourcesSet>();
        }

        Ref<FrameResourceTree> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(FrameResourceTree) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<FrameResourceTree>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FrameResourceTree> result = FrameResourceTree::create()
     *     .setFrame(...)
     *     .setResources(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setChildFrames(Ref<JSON::ArrayOf<Protocol::Page::FrameResourceTree>>&& in_opt_childFrames)
    {
        JSON::ObjectBase::setArray("childFrames"_s, WTFMove(in_opt_childFrames));
    }
};

/* Search result for resource. */
class SearchResult final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        FrameIdSet = 1 << 1,
        MatchesCountSet = 1 << 2,
        AllFieldsSet = (UrlSet | FrameIdSet | MatchesCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SearchResult*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class SearchResult;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const String& in_frameId)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId already set");
            m_result->setString("frameId"_s, in_frameId);
            return castState<FrameIdSet>();
        }

        Builder<STATE | MatchesCountSet>& setMatchesCount(double in_matchesCount)
        {
            static_assert(!(STATE & MatchesCountSet), "property matchesCount already set");
            m_result->setDouble("matchesCount"_s, in_matchesCount);
            return castState<MatchesCountSet>();
        }

        Ref<SearchResult> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(SearchResult) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SearchResult>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SearchResult> result = SearchResult::create()
     *     .setUrl(...)
     *     .setFrameId(...)
     *     .setMatchesCount(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setRequestId(const String& in_opt_requestId)
    {
        JSON::ObjectBase::setString("requestId"_s, in_opt_requestId);
    }
};

/* Cookie object */
class Cookie final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        ExpiresSet = 1 << 4,
        SessionSet = 1 << 5,
        HttpOnlySet = 1 << 6,
        SecureSet = 1 << 7,
        SameSiteSet = 1 << 8,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | SessionSet | HttpOnlySet | SecureSet | SameSiteSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Cookie*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Cookie;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, in_value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& in_domain)
        {
            static_assert(!(STATE & DomainSet), "property domain already set");
            m_result->setString("domain"_s, in_domain);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& in_path)
        {
            static_assert(!(STATE & PathSet), "property path already set");
            m_result->setString("path"_s, in_path);
            return castState<PathSet>();
        }

        Builder<STATE | ExpiresSet>& setExpires(double in_expires)
        {
            static_assert(!(STATE & ExpiresSet), "property expires already set");
            m_result->setDouble("expires"_s, in_expires);
            return castState<ExpiresSet>();
        }

        Builder<STATE | SessionSet>& setSession(bool in_session)
        {
            static_assert(!(STATE & SessionSet), "property session already set");
            m_result->setBoolean("session"_s, in_session);
            return castState<SessionSet>();
        }

        Builder<STATE | HttpOnlySet>& setHttpOnly(bool in_httpOnly)
        {
            static_assert(!(STATE & HttpOnlySet), "property httpOnly already set");
            m_result->setBoolean("httpOnly"_s, in_httpOnly);
            return castState<HttpOnlySet>();
        }

        Builder<STATE | SecureSet>& setSecure(bool in_secure)
        {
            static_assert(!(STATE & SecureSet), "property secure already set");
            m_result->setBoolean("secure"_s, in_secure);
            return castState<SecureSet>();
        }

        Builder<STATE | SameSiteSet>& setSameSite(Protocol::Page::CookieSameSitePolicy in_sameSite)
        {
            static_assert(!(STATE & SameSiteSet), "property sameSite already set");
            m_result->setString("sameSite"_s, Protocol::Helpers::getEnumConstantValue(in_sameSite));
            return castState<SameSiteSet>();
        }

        Ref<Cookie> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Cookie) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Cookie>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Cookie> result = Cookie::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .setExpires(...)
     *     .setSession(...)
     *     .setHttpOnly(...)
     *     .setSecure(...)
     *     .setSameSite(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral nameKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral valueKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral domainKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral pathKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral expiresKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral sessionKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral httpOnlyKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral secureKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral sameSiteKey;
};

/* Accessibility Node */
class AXNode final : public JSON::ObjectBase {
public:
    // Named after property name 'checked' while generating AXNode.
    enum class Checked {
        True = 119,
        False = 120,
        Mixed = 121,
    }; // enum class Checked

    // Named after property name 'pressed' while generating AXNode.
    enum class Pressed {
        True = 119,
        False = 120,
        Mixed = 121,
    }; // enum class Pressed

    // Named after property name 'invalid' while generating AXNode.
    enum class Invalid {
        True = 119,
        False = 120,
        Grammar = 127,
        Spelling = 128,
    }; // enum class Invalid

    enum {
        NoFieldsSet = 0,
        RoleSet = 1 << 0,
        AllFieldsSet = (RoleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*AXNode*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class AXNode;
    public:

        Builder<STATE | RoleSet>& setRole(const String& in_role)
        {
            static_assert(!(STATE & RoleSet), "property role already set");
            m_result->setString("role"_s, in_role);
            return castState<RoleSet>();
        }

        Ref<AXNode> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(AXNode) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<AXNode>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<AXNode> result = AXNode::create()
     *     .setRole(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& in_opt_name)
    {
        JSON::ObjectBase::setString("name"_s, in_opt_name);
    }

    void setValue(Ref<JSON::Value>&& in_opt_value)
    {
        JSON::ObjectBase::setValue("value"_s, WTFMove(in_opt_value));
    }

    void setDescription(const String& in_opt_description)
    {
        JSON::ObjectBase::setString("description"_s, in_opt_description);
    }

    void setKeyshortcuts(const String& in_opt_keyshortcuts)
    {
        JSON::ObjectBase::setString("keyshortcuts"_s, in_opt_keyshortcuts);
    }

    void setRoledescription(const String& in_opt_roledescription)
    {
        JSON::ObjectBase::setString("roledescription"_s, in_opt_roledescription);
    }

    void setValuetext(const String& in_opt_valuetext)
    {
        JSON::ObjectBase::setString("valuetext"_s, in_opt_valuetext);
    }

    void setDisabled(bool in_opt_disabled)
    {
        JSON::ObjectBase::setBoolean("disabled"_s, in_opt_disabled);
    }

    void setExpanded(bool in_opt_expanded)
    {
        JSON::ObjectBase::setBoolean("expanded"_s, in_opt_expanded);
    }

    void setFocused(bool in_opt_focused)
    {
        JSON::ObjectBase::setBoolean("focused"_s, in_opt_focused);
    }

    void setModal(bool in_opt_modal)
    {
        JSON::ObjectBase::setBoolean("modal"_s, in_opt_modal);
    }

    void setMultiline(bool in_opt_multiline)
    {
        JSON::ObjectBase::setBoolean("multiline"_s, in_opt_multiline);
    }

    void setMultiselectable(bool in_opt_multiselectable)
    {
        JSON::ObjectBase::setBoolean("multiselectable"_s, in_opt_multiselectable);
    }

    void setReadonly(bool in_opt_readonly)
    {
        JSON::ObjectBase::setBoolean("readonly"_s, in_opt_readonly);
    }

    void setRequired(bool in_opt_required)
    {
        JSON::ObjectBase::setBoolean("required"_s, in_opt_required);
    }

    void setSelected(bool in_opt_selected)
    {
        JSON::ObjectBase::setBoolean("selected"_s, in_opt_selected);
    }

    void setChecked(Checked in_opt_checked)
    {
        JSON::ObjectBase::setString("checked"_s, Protocol::Helpers::getEnumConstantValue(in_opt_checked));
    }

    void setPressed(Pressed in_opt_pressed)
    {
        JSON::ObjectBase::setString("pressed"_s, Protocol::Helpers::getEnumConstantValue(in_opt_pressed));
    }

    void setLevel(int in_opt_level)
    {
        JSON::ObjectBase::setInteger("level"_s, in_opt_level);
    }

    void setValuemin(double in_opt_valuemin)
    {
        JSON::ObjectBase::setDouble("valuemin"_s, in_opt_valuemin);
    }

    void setValuemax(double in_opt_valuemax)
    {
        JSON::ObjectBase::setDouble("valuemax"_s, in_opt_valuemax);
    }

    void setAutocomplete(const String& in_opt_autocomplete)
    {
        JSON::ObjectBase::setString("autocomplete"_s, in_opt_autocomplete);
    }

    void setHaspopup(const String& in_opt_haspopup)
    {
        JSON::ObjectBase::setString("haspopup"_s, in_opt_haspopup);
    }

    void setInvalid(Invalid in_opt_invalid)
    {
        JSON::ObjectBase::setString("invalid"_s, Protocol::Helpers::getEnumConstantValue(in_opt_invalid));
    }

    void setOrientation(const String& in_opt_orientation)
    {
        JSON::ObjectBase::setString("orientation"_s, in_opt_orientation);
    }

    void setFocusable(bool in_opt_focusable)
    {
        JSON::ObjectBase::setBoolean("focusable"_s, in_opt_focusable);
    }

    void setChildren(Ref<JSON::ArrayOf<Protocol::Page::AXNode>>&& in_opt_children)
    {
        JSON::ObjectBase::setArray("children"_s, WTFMove(in_opt_children));
    }

    void setFound(bool in_opt_found)
    {
        JSON::ObjectBase::setBoolean("found"_s, in_opt_found);
    }
};

class Insets final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TopSet = 1 << 0,
        RightSet = 1 << 1,
        BottomSet = 1 << 2,
        LeftSet = 1 << 3,
        AllFieldsSet = (TopSet | RightSet | BottomSet | LeftSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Insets*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Insets;
    public:

        Builder<STATE | TopSet>& setTop(double in_top)
        {
            static_assert(!(STATE & TopSet), "property top already set");
            m_result->setDouble("top"_s, in_top);
            return castState<TopSet>();
        }

        Builder<STATE | RightSet>& setRight(double in_right)
        {
            static_assert(!(STATE & RightSet), "property right already set");
            m_result->setDouble("right"_s, in_right);
            return castState<RightSet>();
        }

        Builder<STATE | BottomSet>& setBottom(double in_bottom)
        {
            static_assert(!(STATE & BottomSet), "property bottom already set");
            m_result->setDouble("bottom"_s, in_bottom);
            return castState<BottomSet>();
        }

        Builder<STATE | LeftSet>& setLeft(double in_left)
        {
            static_assert(!(STATE & LeftSet), "property left already set");
            m_result->setDouble("left"_s, in_left);
            return castState<LeftSet>();
        }

        Ref<Insets> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Insets) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Insets>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Insets> result = Insets::create()
     *     .setTop(...)
     *     .setRight(...)
     *     .setBottom(...)
     *     .setLeft(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Page

namespace Playwright {

/* Same-Site policy of a cookie. */
enum class CookieSameSitePolicy {
    None = 223,
    Lax = 224,
    Strict = 225,
}; // enum class CookieSameSitePolicy

/* Cookie object */
class Cookie final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        ExpiresSet = 1 << 4,
        HttpOnlySet = 1 << 5,
        SecureSet = 1 << 6,
        SessionSet = 1 << 7,
        SameSiteSet = 1 << 8,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | HttpOnlySet | SecureSet | SessionSet | SameSiteSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Cookie*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Cookie;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, in_value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& in_domain)
        {
            static_assert(!(STATE & DomainSet), "property domain already set");
            m_result->setString("domain"_s, in_domain);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& in_path)
        {
            static_assert(!(STATE & PathSet), "property path already set");
            m_result->setString("path"_s, in_path);
            return castState<PathSet>();
        }

        Builder<STATE | ExpiresSet>& setExpires(double in_expires)
        {
            static_assert(!(STATE & ExpiresSet), "property expires already set");
            m_result->setDouble("expires"_s, in_expires);
            return castState<ExpiresSet>();
        }

        Builder<STATE | HttpOnlySet>& setHttpOnly(bool in_httpOnly)
        {
            static_assert(!(STATE & HttpOnlySet), "property httpOnly already set");
            m_result->setBoolean("httpOnly"_s, in_httpOnly);
            return castState<HttpOnlySet>();
        }

        Builder<STATE | SecureSet>& setSecure(bool in_secure)
        {
            static_assert(!(STATE & SecureSet), "property secure already set");
            m_result->setBoolean("secure"_s, in_secure);
            return castState<SecureSet>();
        }

        Builder<STATE | SessionSet>& setSession(bool in_session)
        {
            static_assert(!(STATE & SessionSet), "property session already set");
            m_result->setBoolean("session"_s, in_session);
            return castState<SessionSet>();
        }

        Builder<STATE | SameSiteSet>& setSameSite(Protocol::Playwright::CookieSameSitePolicy in_sameSite)
        {
            static_assert(!(STATE & SameSiteSet), "property sameSite already set");
            m_result->setString("sameSite"_s, Protocol::Helpers::getEnumConstantValue(in_sameSite));
            return castState<SameSiteSet>();
        }

        Ref<Cookie> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Cookie) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Cookie>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Cookie> result = Cookie::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .setExpires(...)
     *     .setHttpOnly(...)
     *     .setSecure(...)
     *     .setSession(...)
     *     .setSameSite(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Cookie object */
class SetCookieParam final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SetCookieParam*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class SetCookieParam;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, in_value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& in_domain)
        {
            static_assert(!(STATE & DomainSet), "property domain already set");
            m_result->setString("domain"_s, in_domain);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& in_path)
        {
            static_assert(!(STATE & PathSet), "property path already set");
            m_result->setString("path"_s, in_path);
            return castState<PathSet>();
        }

        Ref<SetCookieParam> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(SetCookieParam) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<SetCookieParam>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SetCookieParam> result = SetCookieParam::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setExpires(double in_opt_expires)
    {
        JSON::ObjectBase::setDouble("expires"_s, in_opt_expires);
    }

    void setHttpOnly(bool in_opt_httpOnly)
    {
        JSON::ObjectBase::setBoolean("httpOnly"_s, in_opt_httpOnly);
    }

    void setSecure(bool in_opt_secure)
    {
        JSON::ObjectBase::setBoolean("secure"_s, in_opt_secure);
    }

    void setSession(bool in_opt_session)
    {
        JSON::ObjectBase::setBoolean("session"_s, in_opt_session);
    }

    void setSameSite(Protocol::Playwright::CookieSameSitePolicy in_opt_sameSite)
    {
        JSON::ObjectBase::setString("sameSite"_s, Protocol::Helpers::getEnumConstantValue(in_opt_sameSite));
    }
};

/* Name-value pair */
class NameValue final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*NameValue*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class NameValue;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setString("value"_s, in_value);
            return castState<ValueSet>();
        }

        Ref<NameValue> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(NameValue) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<NameValue>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<NameValue> result = NameValue::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Origin object */
class OriginStorage final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        OriginSet = 1 << 0,
        ItemsSet = 1 << 1,
        AllFieldsSet = (OriginSet | ItemsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*OriginStorage*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class OriginStorage;
    public:

        Builder<STATE | OriginSet>& setOrigin(const String& in_origin)
        {
            static_assert(!(STATE & OriginSet), "property origin already set");
            m_result->setString("origin"_s, in_origin);
            return castState<OriginSet>();
        }

        Builder<STATE | ItemsSet>& setItems(Ref<JSON::ArrayOf<Protocol::Playwright::NameValue>>&& in_items)
        {
            static_assert(!(STATE & ItemsSet), "property items already set");
            m_result->setArray("items"_s, WTFMove(in_items));
            return castState<ItemsSet>();
        }

        Ref<OriginStorage> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(OriginStorage) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<OriginStorage>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<OriginStorage> result = OriginStorage::create()
     *     .setOrigin(...)
     *     .setItems(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Geolocation */
class Geolocation final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TimestampSet = 1 << 0,
        LatitudeSet = 1 << 1,
        LongitudeSet = 1 << 2,
        AccuracySet = 1 << 3,
        AllFieldsSet = (TimestampSet | LatitudeSet | LongitudeSet | AccuracySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Geolocation*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Geolocation;
    public:

        Builder<STATE | TimestampSet>& setTimestamp(double in_timestamp)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp already set");
            m_result->setDouble("timestamp"_s, in_timestamp);
            return castState<TimestampSet>();
        }

        Builder<STATE | LatitudeSet>& setLatitude(double in_latitude)
        {
            static_assert(!(STATE & LatitudeSet), "property latitude already set");
            m_result->setDouble("latitude"_s, in_latitude);
            return castState<LatitudeSet>();
        }

        Builder<STATE | LongitudeSet>& setLongitude(double in_longitude)
        {
            static_assert(!(STATE & LongitudeSet), "property longitude already set");
            m_result->setDouble("longitude"_s, in_longitude);
            return castState<LongitudeSet>();
        }

        Builder<STATE | AccuracySet>& setAccuracy(double in_accuracy)
        {
            static_assert(!(STATE & AccuracySet), "property accuracy already set");
            m_result->setDouble("accuracy"_s, in_accuracy);
            return castState<AccuracySet>();
        }

        Ref<Geolocation> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Geolocation) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Geolocation>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Geolocation> result = Geolocation::create()
     *     .setTimestamp(...)
     *     .setLatitude(...)
     *     .setLongitude(...)
     *     .setAccuracy(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Playwright

namespace Recording {

/* The type of the recording. */
enum class Type {
    Canvas2D = 62,
    OffscreenCanvas2D = 63,
    CanvasBitmapRenderer = 227,
    CanvasWebGL = 228,
    CanvasWebGL2 = 229,
}; // enum class Type

enum class Initiator {
    Frontend = 230,
    Console = 231,
    AutoCapture = 232,
}; // enum class Initiator

/* Information about the initial state of the recorded object. */
class InitialState final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InitialState*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class InitialState;
    public:

        Ref<InitialState> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(InitialState) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<InitialState>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InitialState> result = InitialState::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setAttributes(Ref<JSON::Object>&& in_opt_attributes)
    {
        JSON::ObjectBase::setObject("attributes"_s, WTFMove(in_opt_attributes));
    }

    void setStates(Ref<JSON::ArrayOf<JSON::Object>>&& in_opt_states)
    {
        JSON::ObjectBase::setArray("states"_s, WTFMove(in_opt_states));
    }

    void setParameters(Ref<JSON::ArrayOf<JSON::Value>>&& in_opt_parameters)
    {
        JSON::ObjectBase::setArray("parameters"_s, WTFMove(in_opt_parameters));
    }

    void setContent(const String& in_opt_content)
    {
        JSON::ObjectBase::setString("content"_s, in_opt_content);
    }
};

/* Container object for a single frame of the recording. */
class Frame final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ActionsSet = 1 << 0,
        AllFieldsSet = (ActionsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Frame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Frame;
    public:

        Builder<STATE | ActionsSet>& setActions(Ref<JSON::ArrayOf<JSON::Value>>&& in_actions)
        {
            static_assert(!(STATE & ActionsSet), "property actions already set");
            m_result->setArray("actions"_s, WTFMove(in_actions));
            return castState<ActionsSet>();
        }

        Ref<Frame> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Frame) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Frame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Frame> result = Frame::create()
     *     .setActions(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setDuration(double in_opt_duration)
    {
        JSON::ObjectBase::setDouble("duration"_s, in_opt_duration);
    }

    void setIncomplete(bool in_opt_incomplete)
    {
        JSON::ObjectBase::setBoolean("incomplete"_s, in_opt_incomplete);
    }
};

class Recording final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        VersionSet = 1 << 0,
        TypeSet = 1 << 1,
        InitialStateSet = 1 << 2,
        DataSet = 1 << 3,
        AllFieldsSet = (VersionSet | TypeSet | InitialStateSet | DataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Recording*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Recording;
    public:

        Builder<STATE | VersionSet>& setVersion(int in_version)
        {
            static_assert(!(STATE & VersionSet), "property version already set");
            m_result->setInteger("version"_s, in_version);
            return castState<VersionSet>();
        }

        Builder<STATE | TypeSet>& setType(Protocol::Recording::Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Builder<STATE | InitialStateSet>& setInitialState(Ref<Protocol::Recording::InitialState>&& in_initialState)
        {
            static_assert(!(STATE & InitialStateSet), "property initialState already set");
            m_result->setObject("initialState"_s, WTFMove(in_initialState));
            return castState<InitialStateSet>();
        }

        Builder<STATE | DataSet>& setData(Ref<JSON::ArrayOf<JSON::Value>>&& in_data)
        {
            static_assert(!(STATE & DataSet), "property data already set");
            m_result->setArray("data"_s, WTFMove(in_data));
            return castState<DataSet>();
        }

        Ref<Recording> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Recording) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Recording>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Recording> result = Recording::create()
     *     .setVersion(...)
     *     .setType(...)
     *     .setInitialState(...)
     *     .setData(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setName(const String& in_opt_name)
    {
        JSON::ObjectBase::setString("name"_s, in_opt_name);
    }
};

} // Recording

namespace Runtime {

/* Mirror object referencing original JavaScript object. */
class RemoteObject final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating RemoteObject.
    enum class Type {
        Object = 233,
        Function = 234,
        Undefined = 235,
        String = 151,
        Number = 150,
        Boolean = 236,
        Symbol = 237,
        Bigint = 238,
    }; // enum class Type

    // Named after property name 'subtype' while generating RemoteObject.
    enum class Subtype {
        Array = 152,
        Null = 153,
        Node = 239,
        Regexp = 240,
        Date = 125,
        Error = 95,
        Map = 241,
        Set = 242,
        Weakmap = 243,
        Weakset = 244,
        Iterator = 245,
        Class = 246,
        Proxy = 247,
    }; // enum class Subtype

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RemoteObject*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class RemoteObject;
    public:

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<RemoteObject> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(RemoteObject) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<RemoteObject>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RemoteObject> result = RemoteObject::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSubtype(Subtype in_opt_subtype)
    {
        JSON::ObjectBase::setString("subtype"_s, Protocol::Helpers::getEnumConstantValue(in_opt_subtype));
    }

    void setClassName(const String& in_opt_className)
    {
        JSON::ObjectBase::setString("className"_s, in_opt_className);
    }

    void setValue(Ref<JSON::Value>&& in_opt_value)
    {
        JSON::ObjectBase::setValue("value"_s, WTFMove(in_opt_value));
    }

    void setDescription(const String& in_opt_description)
    {
        JSON::ObjectBase::setString("description"_s, in_opt_description);
    }

    void setObjectId(const String& in_opt_objectId)
    {
        JSON::ObjectBase::setString("objectId"_s, in_opt_objectId);
    }

    void setSize(int in_opt_size)
    {
        JSON::ObjectBase::setInteger("size"_s, in_opt_size);
    }

    void setClassPrototype(Ref<Protocol::Runtime::RemoteObject>&& in_opt_classPrototype)
    {
        JSON::ObjectBase::setObject("classPrototype"_s, WTFMove(in_opt_classPrototype));
    }

    void setPreview(Ref<Protocol::Runtime::ObjectPreview>&& in_opt_preview)
    {
        JSON::ObjectBase::setObject("preview"_s, WTFMove(in_opt_preview));
    }
};

/* Object containing abbreviated remote object value. */
class ObjectPreview final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating ObjectPreview.
    enum class Type {
        Object = 233,
        Function = 234,
        Undefined = 235,
        String = 151,
        Number = 150,
        Boolean = 236,
        Symbol = 237,
        Bigint = 238,
    }; // enum class Type

    // Named after property name 'subtype' while generating ObjectPreview.
    enum class Subtype {
        Array = 152,
        Null = 153,
        Node = 239,
        Regexp = 240,
        Date = 125,
        Error = 95,
        Map = 241,
        Set = 242,
        Weakmap = 243,
        Weakset = 244,
        Iterator = 245,
        Class = 246,
        Proxy = 247,
    }; // enum class Subtype

    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        LosslessSet = 1 << 1,
        AllFieldsSet = (TypeSet | LosslessSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ObjectPreview*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ObjectPreview;
    public:

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Builder<STATE | LosslessSet>& setLossless(bool in_lossless)
        {
            static_assert(!(STATE & LosslessSet), "property lossless already set");
            m_result->setBoolean("lossless"_s, in_lossless);
            return castState<LosslessSet>();
        }

        Ref<ObjectPreview> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ObjectPreview) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ObjectPreview>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ObjectPreview> result = ObjectPreview::create()
     *     .setType(...)
     *     .setLossless(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSubtype(Subtype in_opt_subtype)
    {
        JSON::ObjectBase::setString("subtype"_s, Protocol::Helpers::getEnumConstantValue(in_opt_subtype));
    }

    void setDescription(const String& in_opt_description)
    {
        JSON::ObjectBase::setString("description"_s, in_opt_description);
    }

    void setOverflow(bool in_opt_overflow)
    {
        JSON::ObjectBase::setBoolean("overflow"_s, in_opt_overflow);
    }

    void setProperties(Ref<JSON::ArrayOf<Protocol::Runtime::PropertyPreview>>&& in_opt_properties)
    {
        JSON::ObjectBase::setArray("properties"_s, WTFMove(in_opt_properties));
    }

    void setEntries(Ref<JSON::ArrayOf<Protocol::Runtime::EntryPreview>>&& in_opt_entries)
    {
        JSON::ObjectBase::setArray("entries"_s, WTFMove(in_opt_entries));
    }

    void setSize(int in_opt_size)
    {
        JSON::ObjectBase::setInteger("size"_s, in_opt_size);
    }
};

class PropertyPreview final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating PropertyPreview.
    enum class Type {
        Object = 233,
        Function = 234,
        Undefined = 235,
        String = 151,
        Number = 150,
        Boolean = 236,
        Symbol = 237,
        Bigint = 238,
        Accessor = 248,
    }; // enum class Type

    // Named after property name 'subtype' while generating PropertyPreview.
    enum class Subtype {
        Array = 152,
        Null = 153,
        Node = 239,
        Regexp = 240,
        Date = 125,
        Error = 95,
        Map = 241,
        Set = 242,
        Weakmap = 243,
        Weakset = 244,
        Iterator = 245,
        Class = 246,
        Proxy = 247,
    }; // enum class Subtype

    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (NameSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*PropertyPreview*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class PropertyPreview;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<PropertyPreview> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(PropertyPreview) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<PropertyPreview>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<PropertyPreview> result = PropertyPreview::create()
     *     .setName(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSubtype(Subtype in_opt_subtype)
    {
        JSON::ObjectBase::setString("subtype"_s, Protocol::Helpers::getEnumConstantValue(in_opt_subtype));
    }

    void setValue(const String& in_opt_value)
    {
        JSON::ObjectBase::setString("value"_s, in_opt_value);
    }

    void setValuePreview(Ref<Protocol::Runtime::ObjectPreview>&& in_opt_valuePreview)
    {
        JSON::ObjectBase::setObject("valuePreview"_s, WTFMove(in_opt_valuePreview));
    }

    void setIsPrivate(bool in_opt_isPrivate)
    {
        JSON::ObjectBase::setBoolean("isPrivate"_s, in_opt_isPrivate);
    }

    void setInternal(bool in_opt_internal)
    {
        JSON::ObjectBase::setBoolean("internal"_s, in_opt_internal);
    }
};

class EntryPreview final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ValueSet = 1 << 0,
        AllFieldsSet = (ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*EntryPreview*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class EntryPreview;
    public:

        Builder<STATE | ValueSet>& setValue(Ref<Protocol::Runtime::ObjectPreview>&& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setObject("value"_s, WTFMove(in_value));
            return castState<ValueSet>();
        }

        Ref<EntryPreview> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(EntryPreview) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<EntryPreview>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<EntryPreview> result = EntryPreview::create()
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setKey(Ref<Protocol::Runtime::ObjectPreview>&& in_opt_key)
    {
        JSON::ObjectBase::setObject("key"_s, WTFMove(in_opt_key));
    }
};

class CollectionEntry final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ValueSet = 1 << 0,
        AllFieldsSet = (ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CollectionEntry*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CollectionEntry;
    public:

        Builder<STATE | ValueSet>& setValue(Ref<Protocol::Runtime::RemoteObject>&& in_value)
        {
            static_assert(!(STATE & ValueSet), "property value already set");
            m_result->setObject("value"_s, WTFMove(in_value));
            return castState<ValueSet>();
        }

        Ref<CollectionEntry> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CollectionEntry) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CollectionEntry>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CollectionEntry> result = CollectionEntry::create()
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setKey(Ref<Protocol::Runtime::RemoteObject>&& in_opt_key)
    {
        JSON::ObjectBase::setObject("key"_s, WTFMove(in_opt_key));
    }
};

/* Object property descriptor. */
class PropertyDescriptor final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*PropertyDescriptor*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class PropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Ref<PropertyDescriptor> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(PropertyDescriptor) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<PropertyDescriptor>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<PropertyDescriptor> result = PropertyDescriptor::create()
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setValue(Ref<Protocol::Runtime::RemoteObject>&& in_opt_value)
    {
        JSON::ObjectBase::setObject("value"_s, WTFMove(in_opt_value));
    }

    void setWritable(bool in_opt_writable)
    {
        JSON::ObjectBase::setBoolean("writable"_s, in_opt_writable);
    }

    void setGet(Ref<Protocol::Runtime::RemoteObject>&& in_opt_get)
    {
        JSON::ObjectBase::setObject("get"_s, WTFMove(in_opt_get));
    }

    void setSet(Ref<Protocol::Runtime::RemoteObject>&& in_opt_set)
    {
        JSON::ObjectBase::setObject("set"_s, WTFMove(in_opt_set));
    }

    void setWasThrown(bool in_opt_wasThrown)
    {
        JSON::ObjectBase::setBoolean("wasThrown"_s, in_opt_wasThrown);
    }

    void setConfigurable(bool in_opt_configurable)
    {
        JSON::ObjectBase::setBoolean("configurable"_s, in_opt_configurable);
    }

    void setEnumerable(bool in_opt_enumerable)
    {
        JSON::ObjectBase::setBoolean("enumerable"_s, in_opt_enumerable);
    }

    void setIsOwn(bool in_opt_isOwn)
    {
        JSON::ObjectBase::setBoolean("isOwn"_s, in_opt_isOwn);
    }

    void setSymbol(Ref<Protocol::Runtime::RemoteObject>&& in_opt_symbol)
    {
        JSON::ObjectBase::setObject("symbol"_s, WTFMove(in_opt_symbol));
    }

    void setIsPrivate(bool in_opt_isPrivate)
    {
        JSON::ObjectBase::setBoolean("isPrivate"_s, in_opt_isPrivate);
    }

    void setNativeGetter(bool in_opt_nativeGetter)
    {
        JSON::ObjectBase::setBoolean("nativeGetter"_s, in_opt_nativeGetter);
    }
};

/* Object internal property descriptor. This property isn't normally visible in JavaScript code. */
class InternalPropertyDescriptor final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InternalPropertyDescriptor*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class InternalPropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Ref<InternalPropertyDescriptor> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(InternalPropertyDescriptor) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<InternalPropertyDescriptor>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InternalPropertyDescriptor> result = InternalPropertyDescriptor::create()
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setValue(Ref<Protocol::Runtime::RemoteObject>&& in_opt_value)
    {
        JSON::ObjectBase::setObject("value"_s, WTFMove(in_opt_value));
    }
};

/* Represents function call argument. Either remote object id <code>objectId</code> or primitive <code>value</code> or neither of (for undefined) them should be specified. */
class CallArgument final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CallArgument*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class CallArgument;
    public:

        Ref<CallArgument> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(CallArgument) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<CallArgument>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CallArgument> result = CallArgument::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setValue(Ref<JSON::Value>&& in_opt_value)
    {
        JSON::ObjectBase::setValue("value"_s, WTFMove(in_opt_value));
    }

    void setObjectId(const String& in_opt_objectId)
    {
        JSON::ObjectBase::setString("objectId"_s, in_opt_objectId);
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral objectIdKey;
};

/* Type of the execution context. */
enum class ExecutionContextType {
    Normal = 5,
    User = 16,
    Internal = 249,
}; // enum class ExecutionContextType

/* Description of an isolated world. */
class ExecutionContextDescription final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        TypeSet = 1 << 1,
        NameSet = 1 << 2,
        FrameIdSet = 1 << 3,
        AllFieldsSet = (IdSet | TypeSet | NameSet | FrameIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ExecutionContextDescription*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ExecutionContextDescription;
    public:

        Builder<STATE | IdSet>& setId(int in_id)
        {
            static_assert(!(STATE & IdSet), "property id already set");
            m_result->setInteger("id"_s, in_id);
            return castState<IdSet>();
        }

        Builder<STATE | TypeSet>& setType(Protocol::Runtime::ExecutionContextType in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const String& in_frameId)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId already set");
            m_result->setString("frameId"_s, in_frameId);
            return castState<FrameIdSet>();
        }

        Ref<ExecutionContextDescription> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ExecutionContextDescription) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ExecutionContextDescription>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ExecutionContextDescription> result = ExecutionContextDescription::create()
     *     .setId(...)
     *     .setType(...)
     *     .setName(...)
     *     .setFrameId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Syntax error type: "none" for no error, "irrecoverable" for unrecoverable errors, "unterminated-literal" for when there is an unterminated literal, "recoverable" for when the expression is unfinished but valid so far. */
enum class SyntaxErrorType {
    None = 9,
    Irrecoverable = 250,
    UnterminatedLiteral = 251,
    Recoverable = 252,
}; // enum class SyntaxErrorType

/* Range of an error in source code. */
class ErrorRange final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartOffsetSet = 1 << 0,
        EndOffsetSet = 1 << 1,
        AllFieldsSet = (StartOffsetSet | EndOffsetSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ErrorRange*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ErrorRange;
    public:

        Builder<STATE | StartOffsetSet>& setStartOffset(int in_startOffset)
        {
            static_assert(!(STATE & StartOffsetSet), "property startOffset already set");
            m_result->setInteger("startOffset"_s, in_startOffset);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | EndOffsetSet>& setEndOffset(int in_endOffset)
        {
            static_assert(!(STATE & EndOffsetSet), "property endOffset already set");
            m_result->setInteger("endOffset"_s, in_endOffset);
            return castState<EndOffsetSet>();
        }

        Ref<ErrorRange> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ErrorRange) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ErrorRange>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ErrorRange> result = ErrorRange::create()
     *     .setStartOffset(...)
     *     .setEndOffset(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class StructureDescription final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StructureDescription*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class StructureDescription;
    public:

        Ref<StructureDescription> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(StructureDescription) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StructureDescription>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StructureDescription> result = StructureDescription::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setFields(Ref<JSON::ArrayOf<String>>&& in_opt_fields)
    {
        JSON::ObjectBase::setArray("fields"_s, WTFMove(in_opt_fields));
    }

    void setOptionalFields(Ref<JSON::ArrayOf<String>>&& in_opt_optionalFields)
    {
        JSON::ObjectBase::setArray("optionalFields"_s, WTFMove(in_opt_optionalFields));
    }

    void setConstructorName(const String& in_opt_constructorName)
    {
        JSON::ObjectBase::setString("constructorName"_s, in_opt_constructorName);
    }

    void setPrototypeStructure(Ref<Protocol::Runtime::StructureDescription>&& in_opt_prototypeStructure)
    {
        JSON::ObjectBase::setObject("prototypeStructure"_s, WTFMove(in_opt_prototypeStructure));
    }

    void setIsImprecise(bool in_opt_isImprecise)
    {
        JSON::ObjectBase::setBoolean("isImprecise"_s, in_opt_isImprecise);
    }
};

class TypeSet final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IsFunctionSet = 1 << 0,
        IsUndefinedSet = 1 << 1,
        IsNullSet = 1 << 2,
        IsBooleanSet = 1 << 3,
        IsIntegerSet = 1 << 4,
        IsNumberSet = 1 << 5,
        IsStringSet = 1 << 6,
        IsObjectSet = 1 << 7,
        IsSymbolSet = 1 << 8,
        IsBigIntSet = 1 << 9,
        AllFieldsSet = (IsFunctionSet | IsUndefinedSet | IsNullSet | IsBooleanSet | IsIntegerSet | IsNumberSet | IsStringSet | IsObjectSet | IsSymbolSet | IsBigIntSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TypeSet*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class TypeSet;
    public:

        Builder<STATE | IsFunctionSet>& setIsFunction(bool in_isFunction)
        {
            static_assert(!(STATE & IsFunctionSet), "property isFunction already set");
            m_result->setBoolean("isFunction"_s, in_isFunction);
            return castState<IsFunctionSet>();
        }

        Builder<STATE | IsUndefinedSet>& setIsUndefined(bool in_isUndefined)
        {
            static_assert(!(STATE & IsUndefinedSet), "property isUndefined already set");
            m_result->setBoolean("isUndefined"_s, in_isUndefined);
            return castState<IsUndefinedSet>();
        }

        Builder<STATE | IsNullSet>& setIsNull(bool in_isNull)
        {
            static_assert(!(STATE & IsNullSet), "property isNull already set");
            m_result->setBoolean("isNull"_s, in_isNull);
            return castState<IsNullSet>();
        }

        Builder<STATE | IsBooleanSet>& setIsBoolean(bool in_isBoolean)
        {
            static_assert(!(STATE & IsBooleanSet), "property isBoolean already set");
            m_result->setBoolean("isBoolean"_s, in_isBoolean);
            return castState<IsBooleanSet>();
        }

        Builder<STATE | IsIntegerSet>& setIsInteger(bool in_isInteger)
        {
            static_assert(!(STATE & IsIntegerSet), "property isInteger already set");
            m_result->setBoolean("isInteger"_s, in_isInteger);
            return castState<IsIntegerSet>();
        }

        Builder<STATE | IsNumberSet>& setIsNumber(bool in_isNumber)
        {
            static_assert(!(STATE & IsNumberSet), "property isNumber already set");
            m_result->setBoolean("isNumber"_s, in_isNumber);
            return castState<IsNumberSet>();
        }

        Builder<STATE | IsStringSet>& setIsString(bool in_isString)
        {
            static_assert(!(STATE & IsStringSet), "property isString already set");
            m_result->setBoolean("isString"_s, in_isString);
            return castState<IsStringSet>();
        }

        Builder<STATE | IsObjectSet>& setIsObject(bool in_isObject)
        {
            static_assert(!(STATE & IsObjectSet), "property isObject already set");
            m_result->setBoolean("isObject"_s, in_isObject);
            return castState<IsObjectSet>();
        }

        Builder<STATE | IsSymbolSet>& setIsSymbol(bool in_isSymbol)
        {
            static_assert(!(STATE & IsSymbolSet), "property isSymbol already set");
            m_result->setBoolean("isSymbol"_s, in_isSymbol);
            return castState<IsSymbolSet>();
        }

        Builder<STATE | IsBigIntSet>& setIsBigInt(bool in_isBigInt)
        {
            static_assert(!(STATE & IsBigIntSet), "property isBigInt already set");
            m_result->setBoolean("isBigInt"_s, in_isBigInt);
            return castState<IsBigIntSet>();
        }

        Ref<TypeSet> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(TypeSet) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TypeSet>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TypeSet> result = TypeSet::create()
     *     .setIsFunction(...)
     *     .setIsUndefined(...)
     *     .setIsNull(...)
     *     .setIsBoolean(...)
     *     .setIsInteger(...)
     *     .setIsNumber(...)
     *     .setIsString(...)
     *     .setIsObject(...)
     *     .setIsSymbol(...)
     *     .setIsBigInt(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

/* Container for type information that has been gathered. */
class TypeDescription final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IsValidSet = 1 << 0,
        AllFieldsSet = (IsValidSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TypeDescription*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class TypeDescription;
    public:

        Builder<STATE | IsValidSet>& setIsValid(bool in_isValid)
        {
            static_assert(!(STATE & IsValidSet), "property isValid already set");
            m_result->setBoolean("isValid"_s, in_isValid);
            return castState<IsValidSet>();
        }

        Ref<TypeDescription> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(TypeDescription) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TypeDescription>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TypeDescription> result = TypeDescription::create()
     *     .setIsValid(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setLeastCommonAncestor(const String& in_opt_leastCommonAncestor)
    {
        JSON::ObjectBase::setString("leastCommonAncestor"_s, in_opt_leastCommonAncestor);
    }

    void setTypeSet(Ref<Protocol::Runtime::TypeSet>&& in_opt_typeSet)
    {
        JSON::ObjectBase::setObject("typeSet"_s, WTFMove(in_opt_typeSet));
    }

    void setStructures(Ref<JSON::ArrayOf<Protocol::Runtime::StructureDescription>>&& in_opt_structures)
    {
        JSON::ObjectBase::setArray("structures"_s, WTFMove(in_opt_structures));
    }

    void setIsTruncated(bool in_opt_isTruncated)
    {
        JSON::ObjectBase::setBoolean("isTruncated"_s, in_opt_isTruncated);
    }
};

/* Describes the location of an expression we want type information for. */
class TypeLocation final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        TypeInformationDescriptorSet = 1 << 0,
        SourceIDSet = 1 << 1,
        DivotSet = 1 << 2,
        AllFieldsSet = (TypeInformationDescriptorSet | SourceIDSet | DivotSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TypeLocation*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class TypeLocation;
    public:

        Builder<STATE | TypeInformationDescriptorSet>& setTypeInformationDescriptor(int in_typeInformationDescriptor)
        {
            static_assert(!(STATE & TypeInformationDescriptorSet), "property typeInformationDescriptor already set");
            m_result->setInteger("typeInformationDescriptor"_s, in_typeInformationDescriptor);
            return castState<TypeInformationDescriptorSet>();
        }

        Builder<STATE | SourceIDSet>& setSourceID(const String& in_sourceID)
        {
            static_assert(!(STATE & SourceIDSet), "property sourceID already set");
            m_result->setString("sourceID"_s, in_sourceID);
            return castState<SourceIDSet>();
        }

        Builder<STATE | DivotSet>& setDivot(int in_divot)
        {
            static_assert(!(STATE & DivotSet), "property divot already set");
            m_result->setInteger("divot"_s, in_divot);
            return castState<DivotSet>();
        }

        Ref<TypeLocation> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(TypeLocation) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TypeLocation>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TypeLocation> result = TypeLocation::create()
     *     .setTypeInformationDescriptor(...)
     *     .setSourceID(...)
     *     .setDivot(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral typeInformationDescriptorKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral sourceIDKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral divotKey;
};

/* From Wikipedia: a basic block is a portion of the code within a program with only one entry point and only one exit point. This type gives the location of a basic block and if that basic block has executed. */
class BasicBlock final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartOffsetSet = 1 << 0,
        EndOffsetSet = 1 << 1,
        HasExecutedSet = 1 << 2,
        ExecutionCountSet = 1 << 3,
        AllFieldsSet = (StartOffsetSet | EndOffsetSet | HasExecutedSet | ExecutionCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BasicBlock*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class BasicBlock;
    public:

        Builder<STATE | StartOffsetSet>& setStartOffset(int in_startOffset)
        {
            static_assert(!(STATE & StartOffsetSet), "property startOffset already set");
            m_result->setInteger("startOffset"_s, in_startOffset);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | EndOffsetSet>& setEndOffset(int in_endOffset)
        {
            static_assert(!(STATE & EndOffsetSet), "property endOffset already set");
            m_result->setInteger("endOffset"_s, in_endOffset);
            return castState<EndOffsetSet>();
        }

        Builder<STATE | HasExecutedSet>& setHasExecuted(bool in_hasExecuted)
        {
            static_assert(!(STATE & HasExecutedSet), "property hasExecuted already set");
            m_result->setBoolean("hasExecuted"_s, in_hasExecuted);
            return castState<HasExecutedSet>();
        }

        Builder<STATE | ExecutionCountSet>& setExecutionCount(int in_executionCount)
        {
            static_assert(!(STATE & ExecutionCountSet), "property executionCount already set");
            m_result->setInteger("executionCount"_s, in_executionCount);
            return castState<ExecutionCountSet>();
        }

        Ref<BasicBlock> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(BasicBlock) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<BasicBlock>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BasicBlock> result = BasicBlock::create()
     *     .setStartOffset(...)
     *     .setEndOffset(...)
     *     .setHasExecuted(...)
     *     .setExecutionCount(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // Runtime

namespace ScriptProfiler {

enum class EventType {
    API = 253,
    Microtask = 254,
    Other = 185,
}; // enum class EventType

class Event final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartTimeSet = 1 << 0,
        EndTimeSet = 1 << 1,
        TypeSet = 1 << 2,
        AllFieldsSet = (StartTimeSet | EndTimeSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Event*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Event;
    public:

        Builder<STATE | StartTimeSet>& setStartTime(double in_startTime)
        {
            static_assert(!(STATE & StartTimeSet), "property startTime already set");
            m_result->setDouble("startTime"_s, in_startTime);
            return castState<StartTimeSet>();
        }

        Builder<STATE | EndTimeSet>& setEndTime(double in_endTime)
        {
            static_assert(!(STATE & EndTimeSet), "property endTime already set");
            m_result->setDouble("endTime"_s, in_endTime);
            return castState<EndTimeSet>();
        }

        Builder<STATE | TypeSet>& setType(Protocol::ScriptProfiler::EventType in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<Event> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Event) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Event>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Event> result = Event::create()
     *     .setStartTime(...)
     *     .setEndTime(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class ExpressionLocation final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LineSet = 1 << 0,
        ColumnSet = 1 << 1,
        AllFieldsSet = (LineSet | ColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ExpressionLocation*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class ExpressionLocation;
    public:

        Builder<STATE | LineSet>& setLine(int in_line)
        {
            static_assert(!(STATE & LineSet), "property line already set");
            m_result->setInteger("line"_s, in_line);
            return castState<LineSet>();
        }

        Builder<STATE | ColumnSet>& setColumn(int in_column)
        {
            static_assert(!(STATE & ColumnSet), "property column already set");
            m_result->setInteger("column"_s, in_column);
            return castState<ColumnSet>();
        }

        Ref<ExpressionLocation> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(ExpressionLocation) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<ExpressionLocation>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ExpressionLocation> result = ExpressionLocation::create()
     *     .setLine(...)
     *     .setColumn(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class StackFrame final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SourceIDSet = 1 << 0,
        NameSet = 1 << 1,
        LineSet = 1 << 2,
        ColumnSet = 1 << 3,
        UrlSet = 1 << 4,
        AllFieldsSet = (SourceIDSet | NameSet | LineSet | ColumnSet | UrlSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StackFrame*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class StackFrame;
    public:

        Builder<STATE | SourceIDSet>& setSourceID(const String& in_sourceID)
        {
            static_assert(!(STATE & SourceIDSet), "property sourceID already set");
            m_result->setString("sourceID"_s, in_sourceID);
            return castState<SourceIDSet>();
        }

        Builder<STATE | NameSet>& setName(const String& in_name)
        {
            static_assert(!(STATE & NameSet), "property name already set");
            m_result->setString("name"_s, in_name);
            return castState<NameSet>();
        }

        Builder<STATE | LineSet>& setLine(int in_line)
        {
            static_assert(!(STATE & LineSet), "property line already set");
            m_result->setInteger("line"_s, in_line);
            return castState<LineSet>();
        }

        Builder<STATE | ColumnSet>& setColumn(int in_column)
        {
            static_assert(!(STATE & ColumnSet), "property column already set");
            m_result->setInteger("column"_s, in_column);
            return castState<ColumnSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Ref<StackFrame> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(StackFrame) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StackFrame>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StackFrame> result = StackFrame::create()
     *     .setSourceID(...)
     *     .setName(...)
     *     .setLine(...)
     *     .setColumn(...)
     *     .setUrl(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setExpressionLocation(Ref<Protocol::ScriptProfiler::ExpressionLocation>&& in_opt_expressionLocation)
    {
        JSON::ObjectBase::setObject("expressionLocation"_s, WTFMove(in_opt_expressionLocation));
    }
};

class StackTrace final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TimestampSet = 1 << 0,
        StackFramesSet = 1 << 1,
        AllFieldsSet = (TimestampSet | StackFramesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StackTrace*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class StackTrace;
    public:

        Builder<STATE | TimestampSet>& setTimestamp(double in_timestamp)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp already set");
            m_result->setDouble("timestamp"_s, in_timestamp);
            return castState<TimestampSet>();
        }

        Builder<STATE | StackFramesSet>& setStackFrames(Ref<JSON::ArrayOf<Protocol::ScriptProfiler::StackFrame>>&& in_stackFrames)
        {
            static_assert(!(STATE & StackFramesSet), "property stackFrames already set");
            m_result->setArray("stackFrames"_s, WTFMove(in_stackFrames));
            return castState<StackFramesSet>();
        }

        Ref<StackTrace> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(StackTrace) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<StackTrace>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StackTrace> result = StackTrace::create()
     *     .setTimestamp(...)
     *     .setStackFrames(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

class Samples final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StackTracesSet = 1 << 0,
        AllFieldsSet = (StackTracesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Samples*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Samples;
    public:

        Builder<STATE | StackTracesSet>& setStackTraces(Ref<JSON::ArrayOf<Protocol::ScriptProfiler::StackTrace>>&& in_stackTraces)
        {
            static_assert(!(STATE & StackTracesSet), "property stackTraces already set");
            m_result->setArray("stackTraces"_s, WTFMove(in_stackTraces));
            return castState<StackTracesSet>();
        }

        Ref<Samples> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Samples) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Samples>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Samples> result = Samples::create()
     *     .setStackTraces(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // ScriptProfiler

namespace Security {

/* Information about a SSL connection to display in the frontend. */
class Connection final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Connection*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Connection;
    public:

        Ref<Connection> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Connection) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Connection>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Connection> result = Connection::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setProtocol(const String& in_opt_protocol)
    {
        JSON::ObjectBase::setString("protocol"_s, in_opt_protocol);
    }

    void setCipher(const String& in_opt_cipher)
    {
        JSON::ObjectBase::setString("cipher"_s, in_opt_cipher);
    }
};

/* Information about a SSL certificate to display in the frontend. */
class Certificate final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Certificate*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Certificate;
    public:

        Ref<Certificate> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Certificate) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Certificate>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Certificate> result = Certificate::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setSubject(const String& in_opt_subject)
    {
        JSON::ObjectBase::setString("subject"_s, in_opt_subject);
    }

    void setValidFrom(double in_opt_validFrom)
    {
        JSON::ObjectBase::setDouble("validFrom"_s, in_opt_validFrom);
    }

    void setValidUntil(double in_opt_validUntil)
    {
        JSON::ObjectBase::setDouble("validUntil"_s, in_opt_validUntil);
    }

    void setDnsNames(Ref<JSON::ArrayOf<String>>&& in_opt_dnsNames)
    {
        JSON::ObjectBase::setArray("dnsNames"_s, WTFMove(in_opt_dnsNames));
    }

    void setIpAddresses(Ref<JSON::ArrayOf<String>>&& in_opt_ipAddresses)
    {
        JSON::ObjectBase::setArray("ipAddresses"_s, WTFMove(in_opt_ipAddresses));
    }
};

/* Security information for a given Network.Response. */
class Security final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Security*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Security;
    public:

        Ref<Security> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Security) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Security>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Security> result = Security::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setConnection(Ref<Protocol::Security::Connection>&& in_opt_connection)
    {
        JSON::ObjectBase::setObject("connection"_s, WTFMove(in_opt_connection));
    }

    void setCertificate(Ref<Protocol::Security::Certificate>&& in_opt_certificate)
    {
        JSON::ObjectBase::setObject("certificate"_s, WTFMove(in_opt_certificate));
    }
};

} // Security

#if defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
namespace ServiceWorker {

/* ServiceWorker metadata and initial state. */
class Configuration final : public JSON::ObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TargetIdSet = 1 << 0,
        SecurityOriginSet = 1 << 1,
        UrlSet = 1 << 2,
        ContentSet = 1 << 3,
        AllFieldsSet = (TargetIdSet | SecurityOriginSet | UrlSet | ContentSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Configuration*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class Configuration;
    public:

        Builder<STATE | TargetIdSet>& setTargetId(const String& in_targetId)
        {
            static_assert(!(STATE & TargetIdSet), "property targetId already set");
            m_result->setString("targetId"_s, in_targetId);
            return castState<TargetIdSet>();
        }

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& in_securityOrigin)
        {
            static_assert(!(STATE & SecurityOriginSet), "property securityOrigin already set");
            m_result->setString("securityOrigin"_s, in_securityOrigin);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& in_url)
        {
            static_assert(!(STATE & UrlSet), "property url already set");
            m_result->setString("url"_s, in_url);
            return castState<UrlSet>();
        }

        Builder<STATE | ContentSet>& setContent(const String& in_content)
        {
            static_assert(!(STATE & ContentSet), "property content already set");
            m_result->setString("content"_s, in_content);
            return castState<ContentSet>();
        }

        Ref<Configuration> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(Configuration) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<Configuration>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Configuration> result = Configuration::create()
     *     .setTargetId(...)
     *     .setSecurityOrigin(...)
     *     .setUrl(...)
     *     .setContent(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }
};

} // ServiceWorker
#endif // defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER

namespace Target {

/* Description of a target. */
class TargetInfo final : public JSON::ObjectBase {
public:
    // Named after property name 'type' while generating TargetInfo.
    enum class Type {
        Page = 122,
        ServiceWorker = 169,
        Worker = 255,
    }; // enum class Type

    enum {
        NoFieldsSet = 0,
        TargetIdSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (TargetIdSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TargetInfo*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class TargetInfo;
    public:

        Builder<STATE | TargetIdSet>& setTargetId(const String& in_targetId)
        {
            static_assert(!(STATE & TargetIdSet), "property targetId already set");
            m_result->setString("targetId"_s, in_targetId);
            return castState<TargetIdSet>();
        }

        Builder<STATE | TypeSet>& setType(Type in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Ref<TargetInfo> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(TargetInfo) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TargetInfo>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TargetInfo> result = TargetInfo::create()
     *     .setTargetId(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setIsProvisional(bool in_opt_isProvisional)
    {
        JSON::ObjectBase::setBoolean("isProvisional"_s, in_opt_isProvisional);
    }

    void setIsPaused(bool in_opt_isPaused)
    {
        JSON::ObjectBase::setBoolean("isPaused"_s, in_opt_isPaused);
    }
};

} // Target

namespace Timeline {

/* Timeline record type. */
enum class EventType {
    EventDispatch = 256,
    ScheduleStyleRecalculation = 257,
    RecalculateStyles = 258,
    InvalidateLayout = 259,
    Layout = 260,
    Paint = 261,
    Composite = 262,
    RenderingFrame = 263,
    TimerInstall = 264,
    TimerRemove = 265,
    TimerFire = 266,
    EvaluateScript = 267,
    TimeStamp = 268,
    Time = 269,
    TimeEnd = 270,
    FunctionCall = 271,
    ProbeSample = 272,
    ConsoleProfile = 273,
    RequestAnimationFrame = 274,
    CancelAnimationFrame = 275,
    FireAnimationFrame = 276,
    ObserverCallback = 277,
    Screenshot = 278,
}; // enum class EventType

/* Instrument types. */
enum class Instrument {
    ScriptProfiler = 279,
    Timeline = 280,
    CPU = 281,
    Memory = 282,
    Heap = 283,
    Animation = 284,
    Screenshot = 278,
}; // enum class Instrument

/* Timeline record contains information about the recorded activity. */
class TimelineEvent final : public JSON::Object {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        DataSet = 1 << 1,
        AllFieldsSet = (TypeSet | DataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<JSON::Object> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TimelineEvent*/JSON::Object>&& object)
            : m_result(WTFMove(object))
        {
            static_assert(STATE == NoFieldsSet, "builder created in non init state");
        }
        friend class TimelineEvent;
    public:

        Builder<STATE | TypeSet>& setType(Protocol::Timeline::EventType in_type)
        {
            static_assert(!(STATE & TypeSet), "property type already set");
            m_result->setString("type"_s, Protocol::Helpers::getEnumConstantValue(in_type));
            return castState<TypeSet>();
        }

        Builder<STATE | DataSet>& setData(Ref<JSON::Object>&& in_data)
        {
            static_assert(!(STATE & DataSet), "property data already set");
            m_result->setObject("data"_s, WTFMove(in_data));
            return castState<DataSet>();
        }

        Ref<TimelineEvent> release()
        {
            static_assert(STATE == AllFieldsSet, "result is not ready");
            static_assert(sizeof(TimelineEvent) == sizeof(JSON::Object), "cannot cast");

            Ref<JSON::Object> jsonResult = m_result.releaseNonNull();
            auto result = WTFMove(*reinterpret_cast<Ref<TimelineEvent>*>(&jsonResult));
            return result;
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TimelineEvent> result = TimelineEvent::create()
     *     .setType(...)
     *     .setData(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(JSON::Object::create());
    }

    void setChildren(Ref<JSON::ArrayOf<Protocol::Timeline::TimelineEvent>>&& in_opt_children)
    {
        JSON::ObjectBase::setArray("children"_s, WTFMove(in_opt_children));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const ASCIILiteral typeKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral dataKey;
    JS_EXPORT_PRIVATE static const ASCIILiteral childrenKey;
};

} // Timeline

template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Debugger::Location> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Debugger::FunctionDetails> {
static Ref<Protocol::Debugger::FunctionDetails> runtimeCast(Ref<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Debugger::CallFrame> {
static Ref<Protocol::Debugger::CallFrame> runtimeCast(Ref<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Debugger::Scope> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Debugger::Scope::Type> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::RemoteObject> {
static Ref<Protocol::Runtime::RemoteObject> runtimeCast(Ref<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::RemoteObject::Type> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::RemoteObject::Subtype> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::ObjectPreview> {
static Ref<Protocol::Runtime::ObjectPreview> runtimeCast(Ref<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::ObjectPreview::Type> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::ObjectPreview::Subtype> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::PropertyPreview> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::PropertyPreview::Type> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::PropertyPreview::Subtype> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::EntryPreview> {
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::CollectionEntry> {
static Ref<Protocol::Runtime::CollectionEntry> runtimeCast(Ref<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::PropertyDescriptor> {
static Ref<Protocol::Runtime::PropertyDescriptor> runtimeCast(Ref<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Runtime::InternalPropertyDescriptor> {
static Ref<Protocol::Runtime::InternalPropertyDescriptor> runtimeCast(Ref<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Timeline::TimelineEvent> {
static Ref<Protocol::Timeline::TimelineEvent> runtimeCast(Ref<JSON::Value>&& value);
static void assertValueHasExpectedType(JSON::Value*);
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Protocol::Timeline::EventType> {
static void assertValueHasExpectedType(JSON::Value*);
};

namespace Helpers {

template<typename ProtocolEnumType>
std::optional<ProtocolEnumType> parseEnumValueFromString(const String&);

// Enums in the 'Animation' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Animation::AnimationState> parseEnumValueFromString<Protocol::Animation::AnimationState>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Animation::PlaybackDirection> parseEnumValueFromString<Protocol::Animation::PlaybackDirection>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Animation::FillMode> parseEnumValueFromString<Protocol::Animation::FillMode>(const String&);

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
// Enums in the 'CPUProfiler' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::CPUProfiler::ThreadInfo::Type> parseEnumValueFromString<Protocol::CPUProfiler::ThreadInfo::Type>(const String&);
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

// Enums in the 'CSS' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::CSS::StyleSheetOrigin> parseEnumValueFromString<Protocol::CSS::StyleSheetOrigin>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::CSS::PseudoId> parseEnumValueFromString<Protocol::CSS::PseudoId>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::CSS::ForceablePseudoClass> parseEnumValueFromString<Protocol::CSS::ForceablePseudoClass>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::CSS::CSSPropertyStatus> parseEnumValueFromString<Protocol::CSS::CSSPropertyStatus>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::CSS::LayoutFlag> parseEnumValueFromString<Protocol::CSS::LayoutFlag>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::CSS::LayoutContextTypeChangedMode> parseEnumValueFromString<Protocol::CSS::LayoutContextTypeChangedMode>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::CSS::Grouping::Type> parseEnumValueFromString<Protocol::CSS::Grouping::Type>(const String&);

// Enums in the 'Canvas' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Canvas::ColorSpace> parseEnumValueFromString<Protocol::Canvas::ColorSpace>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Canvas::ContextType> parseEnumValueFromString<Protocol::Canvas::ContextType>(const String&);
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Canvas::ProgramType> parseEnumValueFromString<Protocol::Canvas::ProgramType>(const String&);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Canvas::ShaderType> parseEnumValueFromString<Protocol::Canvas::ShaderType>(const String&);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

// Enums in the 'Console' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Console::ChannelSource> parseEnumValueFromString<Protocol::Console::ChannelSource>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Console::ChannelLevel> parseEnumValueFromString<Protocol::Console::ChannelLevel>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Console::ClearReason> parseEnumValueFromString<Protocol::Console::ClearReason>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Console::ConsoleMessage::Level> parseEnumValueFromString<Protocol::Console::ConsoleMessage::Level>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Console::ConsoleMessage::Type> parseEnumValueFromString<Protocol::Console::ConsoleMessage::Type>(const String&);

// Enums in the 'DOM' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOM::PseudoType> parseEnumValueFromString<Protocol::DOM::PseudoType>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOM::ShadowRootType> parseEnumValueFromString<Protocol::DOM::ShadowRootType>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOM::CustomElementState> parseEnumValueFromString<Protocol::DOM::CustomElementState>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOM::LiveRegionRelevant> parseEnumValueFromString<Protocol::DOM::LiveRegionRelevant>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOM::AccessibilityProperties::Checked> parseEnumValueFromString<Protocol::DOM::AccessibilityProperties::Checked>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOM::AccessibilityProperties::Current> parseEnumValueFromString<Protocol::DOM::AccessibilityProperties::Current>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOM::AccessibilityProperties::Invalid> parseEnumValueFromString<Protocol::DOM::AccessibilityProperties::Invalid>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOM::AccessibilityProperties::LiveRegionStatus> parseEnumValueFromString<Protocol::DOM::AccessibilityProperties::LiveRegionStatus>(const String&);

// Enums in the 'DOMDebugger' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOMDebugger::DOMBreakpointType> parseEnumValueFromString<Protocol::DOMDebugger::DOMBreakpointType>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::DOMDebugger::EventBreakpointType> parseEnumValueFromString<Protocol::DOMDebugger::EventBreakpointType>(const String&);

// Enums in the 'Debugger' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Debugger::BreakpointAction::Type> parseEnumValueFromString<Protocol::Debugger::BreakpointAction::Type>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Debugger::Scope::Type> parseEnumValueFromString<Protocol::Debugger::Scope::Type>(const String&);

// Enums in the 'Heap' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Heap::GarbageCollection::Type> parseEnumValueFromString<Protocol::Heap::GarbageCollection::Type>(const String&);

// Enums in the 'IndexedDB' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::IndexedDB::Key::Type> parseEnumValueFromString<Protocol::IndexedDB::Key::Type>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::IndexedDB::KeyPath::Type> parseEnumValueFromString<Protocol::IndexedDB::KeyPath::Type>(const String&);

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
// Enums in the 'Memory' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Memory::CategoryData::Type> parseEnumValueFromString<Protocol::Memory::CategoryData::Type>(const String&);
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

// Enums in the 'Network' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Network::ReferrerPolicy> parseEnumValueFromString<Protocol::Network::ReferrerPolicy>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Network::NetworkStage> parseEnumValueFromString<Protocol::Network::NetworkStage>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Network::ResourceErrorType> parseEnumValueFromString<Protocol::Network::ResourceErrorType>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Network::Response::Source> parseEnumValueFromString<Protocol::Network::Response::Source>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Network::Metrics::Priority> parseEnumValueFromString<Protocol::Network::Metrics::Priority>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Network::Initiator::Type> parseEnumValueFromString<Protocol::Network::Initiator::Type>(const String&);

// Enums in the 'Page' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::Setting> parseEnumValueFromString<Protocol::Page::Setting>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::UserPreferenceName> parseEnumValueFromString<Protocol::Page::UserPreferenceName>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::UserPreferenceValue> parseEnumValueFromString<Protocol::Page::UserPreferenceValue>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::ResourceType> parseEnumValueFromString<Protocol::Page::ResourceType>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::CoordinateSystem> parseEnumValueFromString<Protocol::Page::CoordinateSystem>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::CookieSameSitePolicy> parseEnumValueFromString<Protocol::Page::CookieSameSitePolicy>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::ForcedColors> parseEnumValueFromString<Protocol::Page::ForcedColors>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::AXNode::Checked> parseEnumValueFromString<Protocol::Page::AXNode::Checked>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::AXNode::Pressed> parseEnumValueFromString<Protocol::Page::AXNode::Pressed>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Page::AXNode::Invalid> parseEnumValueFromString<Protocol::Page::AXNode::Invalid>(const String&);

// Enums in the 'Playwright' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Playwright::CookieSameSitePolicy> parseEnumValueFromString<Protocol::Playwright::CookieSameSitePolicy>(const String&);

// Enums in the 'Recording' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Recording::Type> parseEnumValueFromString<Protocol::Recording::Type>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Recording::Initiator> parseEnumValueFromString<Protocol::Recording::Initiator>(const String&);

// Enums in the 'Runtime' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Runtime::ExecutionContextType> parseEnumValueFromString<Protocol::Runtime::ExecutionContextType>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Runtime::SyntaxErrorType> parseEnumValueFromString<Protocol::Runtime::SyntaxErrorType>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Runtime::RemoteObject::Type> parseEnumValueFromString<Protocol::Runtime::RemoteObject::Type>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Runtime::RemoteObject::Subtype> parseEnumValueFromString<Protocol::Runtime::RemoteObject::Subtype>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Runtime::ObjectPreview::Type> parseEnumValueFromString<Protocol::Runtime::ObjectPreview::Type>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Runtime::ObjectPreview::Subtype> parseEnumValueFromString<Protocol::Runtime::ObjectPreview::Subtype>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Runtime::PropertyPreview::Type> parseEnumValueFromString<Protocol::Runtime::PropertyPreview::Type>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Runtime::PropertyPreview::Subtype> parseEnumValueFromString<Protocol::Runtime::PropertyPreview::Subtype>(const String&);

// Enums in the 'ScriptProfiler' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::ScriptProfiler::EventType> parseEnumValueFromString<Protocol::ScriptProfiler::EventType>(const String&);

// Enums in the 'Target' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Target::TargetInfo::Type> parseEnumValueFromString<Protocol::Target::TargetInfo::Type>(const String&);

// Enums in the 'Timeline' Domain
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Timeline::EventType> parseEnumValueFromString<Protocol::Timeline::EventType>(const String&);
template<>
JS_EXPORT_PRIVATE std::optional<Protocol::Timeline::Instrument> parseEnumValueFromString<Protocol::Timeline::Instrument>(const String&);

} // namespace Helpers

} // namespace Protocol

} // namespace Inspector

namespace WTF {

template<typename T> struct DefaultHash;

// Hash declarations in the 'Animation' Domain
template<>
struct DefaultHash<Inspector::Protocol::Animation::AnimationState> : IntHash<Inspector::Protocol::Animation::AnimationState> { };
template<>
struct DefaultHash<Inspector::Protocol::Animation::PlaybackDirection> : IntHash<Inspector::Protocol::Animation::PlaybackDirection> { };
template<>
struct DefaultHash<Inspector::Protocol::Animation::FillMode> : IntHash<Inspector::Protocol::Animation::FillMode> { };

// Hash declarations in the 'CSS' Domain
template<>
struct DefaultHash<Inspector::Protocol::CSS::StyleSheetOrigin> : IntHash<Inspector::Protocol::CSS::StyleSheetOrigin> { };
template<>
struct DefaultHash<Inspector::Protocol::CSS::PseudoId> : IntHash<Inspector::Protocol::CSS::PseudoId> { };
template<>
struct DefaultHash<Inspector::Protocol::CSS::ForceablePseudoClass> : IntHash<Inspector::Protocol::CSS::ForceablePseudoClass> { };
template<>
struct DefaultHash<Inspector::Protocol::CSS::CSSPropertyStatus> : IntHash<Inspector::Protocol::CSS::CSSPropertyStatus> { };
template<>
struct DefaultHash<Inspector::Protocol::CSS::LayoutFlag> : IntHash<Inspector::Protocol::CSS::LayoutFlag> { };
template<>
struct DefaultHash<Inspector::Protocol::CSS::LayoutContextTypeChangedMode> : IntHash<Inspector::Protocol::CSS::LayoutContextTypeChangedMode> { };

// Hash declarations in the 'Canvas' Domain
template<>
struct DefaultHash<Inspector::Protocol::Canvas::ColorSpace> : IntHash<Inspector::Protocol::Canvas::ColorSpace> { };
template<>
struct DefaultHash<Inspector::Protocol::Canvas::ContextType> : IntHash<Inspector::Protocol::Canvas::ContextType> { };
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
template<>
struct DefaultHash<Inspector::Protocol::Canvas::ProgramType> : IntHash<Inspector::Protocol::Canvas::ProgramType> { };
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
template<>
struct DefaultHash<Inspector::Protocol::Canvas::ShaderType> : IntHash<Inspector::Protocol::Canvas::ShaderType> { };
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

// Hash declarations in the 'Console' Domain
template<>
struct DefaultHash<Inspector::Protocol::Console::ChannelSource> : IntHash<Inspector::Protocol::Console::ChannelSource> { };
template<>
struct DefaultHash<Inspector::Protocol::Console::ChannelLevel> : IntHash<Inspector::Protocol::Console::ChannelLevel> { };
template<>
struct DefaultHash<Inspector::Protocol::Console::ClearReason> : IntHash<Inspector::Protocol::Console::ClearReason> { };

// Hash declarations in the 'DOM' Domain
template<>
struct DefaultHash<Inspector::Protocol::DOM::PseudoType> : IntHash<Inspector::Protocol::DOM::PseudoType> { };
template<>
struct DefaultHash<Inspector::Protocol::DOM::ShadowRootType> : IntHash<Inspector::Protocol::DOM::ShadowRootType> { };
template<>
struct DefaultHash<Inspector::Protocol::DOM::CustomElementState> : IntHash<Inspector::Protocol::DOM::CustomElementState> { };
template<>
struct DefaultHash<Inspector::Protocol::DOM::LiveRegionRelevant> : IntHash<Inspector::Protocol::DOM::LiveRegionRelevant> { };

// Hash declarations in the 'DOMDebugger' Domain
template<>
struct DefaultHash<Inspector::Protocol::DOMDebugger::DOMBreakpointType> : IntHash<Inspector::Protocol::DOMDebugger::DOMBreakpointType> { };
template<>
struct DefaultHash<Inspector::Protocol::DOMDebugger::EventBreakpointType> : IntHash<Inspector::Protocol::DOMDebugger::EventBreakpointType> { };

// Hash declarations in the 'Network' Domain
template<>
struct DefaultHash<Inspector::Protocol::Network::ReferrerPolicy> : IntHash<Inspector::Protocol::Network::ReferrerPolicy> { };
template<>
struct DefaultHash<Inspector::Protocol::Network::NetworkStage> : IntHash<Inspector::Protocol::Network::NetworkStage> { };
template<>
struct DefaultHash<Inspector::Protocol::Network::ResourceErrorType> : IntHash<Inspector::Protocol::Network::ResourceErrorType> { };

// Hash declarations in the 'Page' Domain
template<>
struct DefaultHash<Inspector::Protocol::Page::Setting> : IntHash<Inspector::Protocol::Page::Setting> { };
template<>
struct DefaultHash<Inspector::Protocol::Page::UserPreferenceName> : IntHash<Inspector::Protocol::Page::UserPreferenceName> { };
template<>
struct DefaultHash<Inspector::Protocol::Page::UserPreferenceValue> : IntHash<Inspector::Protocol::Page::UserPreferenceValue> { };
template<>
struct DefaultHash<Inspector::Protocol::Page::ResourceType> : IntHash<Inspector::Protocol::Page::ResourceType> { };
template<>
struct DefaultHash<Inspector::Protocol::Page::CoordinateSystem> : IntHash<Inspector::Protocol::Page::CoordinateSystem> { };
template<>
struct DefaultHash<Inspector::Protocol::Page::CookieSameSitePolicy> : IntHash<Inspector::Protocol::Page::CookieSameSitePolicy> { };
template<>
struct DefaultHash<Inspector::Protocol::Page::ForcedColors> : IntHash<Inspector::Protocol::Page::ForcedColors> { };

// Hash declarations in the 'Playwright' Domain
template<>
struct DefaultHash<Inspector::Protocol::Playwright::CookieSameSitePolicy> : IntHash<Inspector::Protocol::Playwright::CookieSameSitePolicy> { };

// Hash declarations in the 'Recording' Domain
template<>
struct DefaultHash<Inspector::Protocol::Recording::Type> : IntHash<Inspector::Protocol::Recording::Type> { };
template<>
struct DefaultHash<Inspector::Protocol::Recording::Initiator> : IntHash<Inspector::Protocol::Recording::Initiator> { };

// Hash declarations in the 'Runtime' Domain
template<>
struct DefaultHash<Inspector::Protocol::Runtime::ExecutionContextType> : IntHash<Inspector::Protocol::Runtime::ExecutionContextType> { };
template<>
struct DefaultHash<Inspector::Protocol::Runtime::SyntaxErrorType> : IntHash<Inspector::Protocol::Runtime::SyntaxErrorType> { };

// Hash declarations in the 'ScriptProfiler' Domain
template<>
struct DefaultHash<Inspector::Protocol::ScriptProfiler::EventType> : IntHash<Inspector::Protocol::ScriptProfiler::EventType> { };

// Hash declarations in the 'Timeline' Domain
template<>
struct DefaultHash<Inspector::Protocol::Timeline::EventType> : IntHash<Inspector::Protocol::Timeline::EventType> { };
template<>
struct DefaultHash<Inspector::Protocol::Timeline::Instrument> : IntHash<Inspector::Protocol::Timeline::Instrument> { };

} // namespace WTF
